/*
 * Decompiled with CFR 0.152.
 */
package kalix.javasdk.testkit;

import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.grpc.GrpcClientSettings;
import akka.stream.Materializer;
import akka.stream.SystemMaterializer;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.time.Duration;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kalix.javasdk.Kalix;
import kalix.javasdk.KalixRunner;
import kalix.javasdk.impl.GrpcClients;
import kalix.javasdk.testkit.KalixProxyContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KalixTestKit {
    private static final Logger log = LoggerFactory.getLogger(KalixTestKit.class);
    private final Kalix kalix;
    private final Settings settings;
    private boolean started = false;
    private KalixProxyContainer proxyContainer;
    private KalixRunner runner;
    private ActorSystem testSystem;

    public KalixTestKit(Kalix kalix) {
        this(kalix, Settings.DEFAULT);
    }

    public KalixTestKit(Kalix kalix, Settings settings) {
        this.kalix = kalix;
        this.settings = settings;
    }

    public KalixTestKit start() {
        return this.start(ConfigFactory.load());
    }

    public KalixTestKit start(Config config) {
        if (this.started) {
            throw new IllegalStateException("KalixTestkit already started");
        }
        int n = KalixTestKit.availableLocalPort();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("kalix.user-function-port", n);
        hashMap.put("kalix.system.akka.coordinated-shutdown.exit-jvm", "off");
        Config config2 = ConfigFactory.parseMap(hashMap);
        this.runner = this.kalix.createRunner(config2.withFallback((ConfigMergeable)config));
        this.runner.run();
        this.testSystem = ActorSystem.create((String)"KalixTestkit");
        this.proxyContainer = new KalixProxyContainer(n);
        this.proxyContainer.start();
        this.started = true;
        GrpcClients.get((ActorSystem)this.runner.system()).setSelfServicePort(this.proxyContainer.getProxyPort());
        return this;
    }

    public String getHost() {
        if (!this.started) {
            throw new IllegalStateException("Need to start KalixTestkit before accessing the host name");
        }
        return this.proxyContainer.getHost();
    }

    public int getPort() {
        if (!this.started) {
            throw new IllegalStateException("Need to start KalixTestkit before accessing the port");
        }
        return this.proxyContainer.getProxyPort();
    }

    public <T> T getGrpcClient(Class<T> clazz) {
        return (T)GrpcClients.get((ActorSystem)this.getActorSystem()).getGrpcClient(clazz, this.getHost(), this.getPort());
    }

    public Materializer getMaterializer() {
        return SystemMaterializer.get((ActorSystem)this.getActorSystem()).materializer();
    }

    public ActorSystem getActorSystem() {
        if (!this.started) {
            throw new IllegalStateException("Need to start KalixTestkit before accessing actor system");
        }
        return this.testSystem;
    }

    @Deprecated(since="0.8.1", forRemoval=true)
    public GrpcClientSettings getGrpcClientSettings() {
        if (!this.started) {
            throw new IllegalStateException("Need to start KalixTestkit before accessing gRPC client settings");
        }
        return GrpcClientSettings.connectToServiceAt((String)this.getHost(), (int)this.getPort(), (ClassicActorSystemProvider)this.testSystem).withTls(false);
    }

    public void stop() {
        try {
            this.proxyContainer.stop();
        }
        catch (Exception exception) {
            log.error("KalixTestkit proxy container failed to stop", (Throwable)exception);
        }
        try {
            this.testSystem.terminate();
            this.testSystem.getWhenTerminated().toCompletableFuture().get(this.settings.stopTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            log.error("KalixTestkit ActorSystem failed to terminate", (Throwable)exception);
        }
        try {
            this.runner.terminate().toCompletableFuture().get(this.settings.stopTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            log.error("KalixTestkit KalixRunner failed to terminate", (Throwable)exception);
        }
        this.started = false;
    }

    public static int availableLocalPort() {
        int n;
        ServerSocket serverSocket = new ServerSocket(0);
        try {
            n = serverSocket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    serverSocket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Couldn't get available local port", iOException);
            }
        }
        serverSocket.close();
        return n;
    }

    public static class Settings {
        public static Duration DEFAULT_STOP_TIMEOUT = Duration.ofSeconds(10L);
        public static Settings DEFAULT = new Settings(DEFAULT_STOP_TIMEOUT);
        public final Duration stopTimeout;

        public Settings(Duration duration) {
            this.stopTimeout = duration;
        }

        public Settings withStopTimeout(Duration duration) {
            return new Settings(duration);
        }
    }
}

