/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.text;

import io.jstuff.text.CharPredicate;
import java.io.IOException;

public class TextMatcher {
    private static final int MAX_INT_MASK = -268435456;
    private static final long MAX_LONG_MASK = -1152921504606846976L;
    private static final byte[] hexValues = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private final String text;
    private final int length;
    private int start;
    private int index;

    public TextMatcher(String text) {
        if (text == null) {
            throw new NullPointerException("TextMatcher text must not be null");
        }
        this.text = text;
        this.length = text.length();
        this.start = 0;
        this.index = 0;
    }

    public String getText() {
        return this.text;
    }

    public char getChar(int index) {
        return this.text.charAt(index);
    }

    public int getLength() {
        return this.length;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        if (start < 0 || start > this.length) {
            throw new IndexOutOfBoundsException(String.valueOf(start));
        }
        this.start = start;
        if (this.index < start) {
            this.index = start;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if (index < 0 || index > this.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        this.index = index;
        if (index < this.start) {
            this.start = index;
        }
    }

    public boolean isAtEnd() {
        return this.index >= this.length;
    }

    public void revert() {
        this.index = this.start;
    }

    public boolean match(char ch) {
        if (this.index >= this.length || this.text.charAt(this.index) != ch) {
            return false;
        }
        this.start = this.index++;
        return true;
    }

    public boolean match(CharSequence target) {
        int len = target.length();
        if (this.index + len > this.length) {
            return false;
        }
        int i = this.index;
        for (int j = 0; j < len; ++j) {
            if (this.text.charAt(i++) == target.charAt(j)) continue;
            return false;
        }
        this.start = this.index;
        this.index = i;
        return true;
    }

    public boolean match(CharPredicate comparison) {
        if (this.index >= this.length || !comparison.test(this.text.charAt(this.index))) {
            return false;
        }
        this.start = this.index++;
        return true;
    }

    public boolean matchAny(String any) {
        if (this.index >= this.length) {
            return false;
        }
        if (any.indexOf(this.text.charAt(this.index)) < 0) {
            return false;
        }
        this.start = this.index++;
        return true;
    }

    public boolean matchSeq(int maxChars, int minChars, CharPredicate comparison) {
        int i;
        int stopper;
        int n = stopper = maxChars > 0 ? Math.min(this.length, i + maxChars) : this.length;
        for (i = this.index; i < stopper && comparison.test(this.text.charAt(i)); ++i) {
        }
        if (i - this.index < minChars) {
            return false;
        }
        this.start = this.index;
        this.index = i;
        return true;
    }

    public boolean matchSeq(int maxChars, CharPredicate comparison) {
        return this.matchSeq(maxChars, 1, comparison);
    }

    public boolean matchSeq(CharPredicate comparison) {
        return this.matchSeq(0, 1, comparison);
    }

    public boolean matchDec(int maxDigits, int minDigits) {
        return this.matchSeq(maxDigits, minDigits, TextMatcher::isDigit);
    }

    public boolean matchDec(int maxDigits) {
        return this.matchSeq(maxDigits, 1, TextMatcher::isDigit);
    }

    public boolean matchDec() {
        return this.matchSeq(0, 1, TextMatcher::isDigit);
    }

    public boolean matchHex(int maxDigits, int minDigits) {
        return this.matchSeq(maxDigits, minDigits, TextMatcher::isHexDigit);
    }

    public boolean matchHex(int maxDigits) {
        return this.matchSeq(maxDigits, 1, TextMatcher::isHexDigit);
    }

    public boolean matchHex() {
        return this.matchSeq(0, 1, TextMatcher::isHexDigit);
    }

    public boolean matchContinue(int maxChars, int minChars, CharPredicate comparison) {
        int i;
        int stopper;
        int n = stopper = maxChars > 0 ? Math.min(this.length, i + maxChars) : this.length;
        for (i = this.index; i < stopper && comparison.test(this.text.charAt(i)); ++i) {
        }
        if (i - this.index < minChars) {
            this.index = this.start;
            return false;
        }
        this.index = i;
        return true;
    }

    public boolean matchContinue(int maxChars, CharPredicate comparison) {
        return this.matchContinue(maxChars, 0, comparison);
    }

    public boolean matchContinue(CharPredicate comparison) {
        return this.matchContinue(0, 0, comparison);
    }

    public void skipAny(String any) {
        this.start = this.index;
        while (this.index < this.length && any.indexOf(this.text.charAt(this.index)) >= 0) {
            ++this.index;
        }
    }

    public void skip(Character ch) {
        this.start = this.index;
        while (this.index < this.length && this.text.charAt(this.index) == ch.charValue()) {
            ++this.index;
        }
    }

    public void skip(CharPredicate comparison) {
        this.start = this.index;
        while (this.index < this.length && comparison.test(this.text.charAt(this.index))) {
            ++this.index;
        }
    }

    public void skipTo(Character ch) {
        this.start = this.index;
        while (this.index < this.length && this.text.charAt(this.index) != ch.charValue()) {
            ++this.index;
        }
    }

    public void skipTo(CharSequence target) {
        this.start = this.index;
        int targetLength = target.length();
        if (targetLength == 0) {
            return;
        }
        if (targetLength == 1) {
            this.skipTo(Character.valueOf(target.charAt(0)));
        } else {
            char firstChar = target.charAt(0);
            int stopper = this.length - targetLength;
            while (this.index <= stopper) {
                if (this.text.charAt(this.index) == firstChar) {
                    int i = this.index + 1;
                    int j = 1;
                    while (this.text.charAt(i++) == target.charAt(j++)) {
                        if (j != targetLength) continue;
                        return;
                    }
                }
                ++this.index;
            }
            this.index = this.length;
        }
    }

    public void skipToEnd() {
        this.start = this.index;
        this.index = this.length;
    }

    public void skipFixed(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int newIndex = this.index + n;
        if (newIndex > this.length) {
            throw new StringIndexOutOfBoundsException(String.valueOf(newIndex));
        }
        this.start = this.index;
        this.index = newIndex;
    }

    public char nextChar() {
        this.start = this.index;
        if (this.index >= this.length) {
            throw new StringIndexOutOfBoundsException(String.valueOf(this.index));
        }
        return this.text.charAt(this.index++);
    }

    public String getString(int start, int end) {
        return this.text.substring(start, end);
    }

    public CharSequence getCharSeq(int start, int end) {
        if (start < 0 || end > this.length || end < start) {
            throw new IndexOutOfBoundsException(String.valueOf(start) + ':' + end);
        }
        return new CharSeq(this.text, start, end);
    }

    public char getResultChar() {
        return this.text.charAt(this.start);
    }

    public String getResult() {
        return this.text.substring(this.start, this.index);
    }

    public void appendResultTo(Appendable a) throws IOException {
        a.append(this.text, this.start, this.index);
    }

    public CharSequence getResultCharSeq() {
        return new CharSeq(this.text, this.start, this.index);
    }

    public int getResultLength() {
        return this.index - this.start;
    }

    public int getResultInt() {
        return this.getInt(this.start, this.index, false);
    }

    public int getResultInt(boolean negative) {
        return this.getInt(this.start, this.index, negative);
    }

    public int getInt(int from, int to) {
        if (to <= from) {
            throw new NumberFormatException();
        }
        int i = from;
        while (i < to && this.text.charAt(i) == '0') {
            if (++i != to) continue;
            return 0;
        }
        int result = TextMatcher.convertDecDigit(this.text.charAt(i++));
        while (i < to) {
            if ((result = result * 10 + TextMatcher.convertDecDigit(this.text.charAt(i++))) >= 0) continue;
            throw new NumberFormatException();
        }
        return result;
    }

    public int getInt(int from, int to, boolean negative) {
        if (to <= from) {
            throw new NumberFormatException();
        }
        int i = from;
        while (i < to && this.text.charAt(i) == '0') {
            if (++i != to) continue;
            return 0;
        }
        int result = 0;
        if (negative) {
            while (i < to) {
                if ((result = result * 10 - TextMatcher.convertDecDigit(this.text.charAt(i++))) < 0) continue;
                throw new NumberFormatException();
            }
        } else {
            while (i < to) {
                if ((result = result * 10 + TextMatcher.convertDecDigit(this.text.charAt(i++))) >= 0) continue;
                throw new NumberFormatException();
            }
        }
        return result;
    }

    public long getResultLong() {
        return this.getLong(this.start, this.index, false);
    }

    public long getResultLong(boolean negative) {
        return this.getLong(this.start, this.index, negative);
    }

    public long getLong(int from, int to) {
        if (to <= from) {
            throw new NumberFormatException();
        }
        int i = from;
        while (i < to && this.text.charAt(i) == '0') {
            if (++i != to) continue;
            return 0L;
        }
        long result = TextMatcher.convertDecDigit(this.text.charAt(i++));
        while (i < to) {
            if ((result = result * 10L + (long)TextMatcher.convertDecDigit(this.text.charAt(i++))) >= 0L) continue;
            throw new NumberFormatException();
        }
        return result;
    }

    public long getLong(int from, int to, boolean negative) {
        if (to <= from) {
            throw new NumberFormatException();
        }
        int i = from;
        while (i < to && this.text.charAt(i) == '0') {
            if (++i != to) continue;
            return 0L;
        }
        long result = 0L;
        if (negative) {
            while (i < to) {
                if ((result = result * 10L - (long)TextMatcher.convertDecDigit(this.text.charAt(i++))) < 0L) continue;
                throw new NumberFormatException();
            }
        } else {
            while (i < to) {
                if ((result = result * 10L + (long)TextMatcher.convertDecDigit(this.text.charAt(i++))) >= 0L) continue;
                throw new NumberFormatException();
            }
        }
        return result;
    }

    public int getResultHexInt() {
        return this.getHexInt(this.start, this.index);
    }

    public int getHexInt(int from, int to) {
        if (to <= from) {
            throw new NumberFormatException();
        }
        int result = TextMatcher.convertHexDigit(this.text.charAt(from));
        for (int i = from + 1; i < to; ++i) {
            if ((result & 0xF0000000) != 0) {
                throw new NumberFormatException();
            }
            result = result << 4 | TextMatcher.convertHexDigit(this.text.charAt(i));
        }
        return result;
    }

    public long getResultHexLong() {
        return this.getHexLong(this.start, this.index);
    }

    public long getHexLong(int from, int to) {
        if (to <= from) {
            throw new NumberFormatException();
        }
        long result = TextMatcher.convertHexDigit(this.text.charAt(from));
        for (int i = from + 1; i < to; ++i) {
            if ((result & 0xF000000000000000L) != 0L) {
                throw new NumberFormatException();
            }
            result = result << 4 | (long)TextMatcher.convertHexDigit(this.text.charAt(i));
        }
        return result;
    }

    public static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static boolean isHexDigit(char ch) {
        return ch < '\u0080' && hexValues[ch] >= 0;
    }

    public static int convertDecDigit(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        throw new NumberFormatException("Illegal decimal digit");
    }

    public static int convertHexDigit(char ch) {
        byte hex;
        if (ch < '\u0080' && (hex = hexValues[ch]) >= 0) {
            return hex;
        }
        throw new NumberFormatException("Illegal hexadecimal digit");
    }

    public static class CharSeq
    implements CharSequence {
        private final String text;
        private final int start;
        private final int end;

        CharSeq(String text, int start, int end) {
            this.text = text;
            this.start = start;
            this.end = end;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) {
            int i;
            if (index >= 0 && (i = index + this.start) < this.end) {
                return this.text.charAt(i);
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            if (start < 0 || end > this.length() || end < start) {
                throw new IndexOutOfBoundsException();
            }
            return new CharSeq(this.text, start + this.start, end + this.start);
        }

        @Override
        public String toString() {
            return this.text.substring(this.start, this.end);
        }
    }
}

