/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.text;

import io.jstuff.text.AlternateMatcher;
import io.jstuff.text.CaseInsensitiveMatcher;
import io.jstuff.text.ContainsMatcher;
import io.jstuff.text.EndsWithMatcher;
import io.jstuff.text.PatternMatcher;
import io.jstuff.text.SimpleMatcher;
import io.jstuff.text.StartsWithMatcher;
import io.jstuff.text.WildcardMatcher;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.regex.Pattern;

@FunctionalInterface
public interface StringMatcher {
    public boolean matches(CharSequence var1);

    public static WildcardMatcher wildcard(String pattern) {
        return new WildcardMatcher(pattern);
    }

    public static WildcardMatcher wildcard(String pattern, char singleMatchChar, char multiMatchChar) {
        return new WildcardMatcher(pattern, singleMatchChar, multiMatchChar);
    }

    public static SimpleMatcher simple(String string) {
        return new SimpleMatcher(string);
    }

    public static CaseInsensitiveMatcher caseInsensitive(String string) {
        return new CaseInsensitiveMatcher(string);
    }

    public static ContainsMatcher contains(String string) {
        return new ContainsMatcher(string);
    }

    public static StartsWithMatcher startsWith(String string) {
        return new StartsWithMatcher(string);
    }

    public static EndsWithMatcher endsWith(String string) {
        return new EndsWithMatcher(string);
    }

    public static PatternMatcher pattern(Pattern pattern) {
        return new PatternMatcher(pattern);
    }

    public static AlternateMatcher alternate(StringMatcher ... matchers) {
        for (StringMatcher matcher : matchers) {
            Objects.requireNonNull(matcher, "Matcher must not be null");
        }
        return new AlternateMatcher(Arrays.copyOf(matchers, matchers.length));
    }

    public static AlternateMatcher alternate(String ... strings) {
        int n = strings.length;
        StringMatcher[] matchers = new StringMatcher[n];
        for (int i = 0; i < n; ++i) {
            matchers[i] = new SimpleMatcher(Objects.requireNonNull(strings[i], "String must not be null"));
        }
        return new AlternateMatcher(matchers);
    }

    public static AlternateMatcher alternate(Collection<String> strings) {
        StringMatcher[] matchers = new StringMatcher[strings.size()];
        int i = 0;
        for (String string : strings) {
            matchers[i++] = new SimpleMatcher(Objects.requireNonNull(string, "String must not be null"));
        }
        return new AlternateMatcher(matchers);
    }

    public static boolean compareCS(CharSequence cs1, int offset1, CharSequence cs2, int offset2, int count) {
        int i = offset1;
        int j = offset2;
        int stopper = offset1 + count;
        while (i < stopper) {
            if (cs1.charAt(i++) == cs2.charAt(j++)) continue;
            return false;
        }
        return true;
    }
}

