/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.text;

import io.jstuff.text.StringMatcher;
import java.util.Objects;

public class ContainsMatcher
implements StringMatcher {
    private final String string;

    public ContainsMatcher(String string) {
        this.string = Objects.requireNonNull(string, "String must not be null");
    }

    @Override
    public boolean matches(CharSequence target) {
        int count = this.string.length() - 1;
        if (count < 0) {
            return true;
        }
        int lastIndex = target.length() - this.string.length();
        if (lastIndex < 0) {
            return false;
        }
        int i = 0;
        char firstChar = this.string.charAt(0);
        while (i <= lastIndex) {
            int j = ContainsMatcher.indexOf(target, firstChar, i, lastIndex);
            if (j < 0) {
                return false;
            }
            i = j + 1;
            if (!StringMatcher.compareCS(target, i, this.string, 1, count)) continue;
            return true;
        }
        return false;
    }

    private static int indexOf(CharSequence cs, char ch, int fromIndex, int lastIndex) {
        for (int i = fromIndex; i <= lastIndex; ++i) {
            if (cs.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ContainsMatcher)) {
            return false;
        }
        return this.string.equals(((ContainsMatcher)obj).string);
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

