/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline.html;

import io.jstuff.pipeline.IntAcceptor;
import io.jstuff.pipeline.html.HTMLEncoder;
import io.jstuff.pipeline.xxml.DecoderBase;
import io.jstuff.pipeline.xxml.MappingEntry;
import java.util.ArrayList;
import java.util.Arrays;

public class HTMLDecoder<R>
extends DecoderBase<R> {
    public static final MappingEntry[] reverseTable;

    public HTMLDecoder(IntAcceptor<? extends R> downstream) {
        super(reverseTable, downstream);
    }

    static {
        int baseEntitiesLength = HTMLEncoder.baseEntities.length;
        int mappedEntitiesLength = HTMLEncoder.mappedEntities.length;
        ArrayList<MappingEntry> list = new ArrayList<MappingEntry>(baseEntitiesLength + mappedEntitiesLength + 4);
        list.add(new MappingEntry(34, "quot"));
        list.add(new MappingEntry(38, "amp"));
        list.add(new MappingEntry(60, "lt"));
        list.add(new MappingEntry(62, "gt"));
        for (int i = 0; i < baseEntitiesLength; ++i) {
            list.add(new MappingEntry(i + 160, HTMLEncoder.baseEntities[i]));
        }
        list.addAll(Arrays.asList(HTMLEncoder.mappedEntities));
        reverseTable = list.toArray(new MappingEntry[0]);
        Arrays.sort(reverseTable);
    }
}

