/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.pipeline;

import io.jstuff.pipeline.AbstractIntAcceptor;

public class StringAcceptor
extends AbstractIntAcceptor<String> {
    public static final int DEFAULT_INITIAL_CAPACITY = 20;
    private final StringBuilder stringBuilder;

    public StringAcceptor(int initialCapacity) {
        this.stringBuilder = new StringBuilder(initialCapacity);
    }

    public StringAcceptor() {
        this(20);
    }

    public StringAcceptor(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }

    @Override
    public void acceptInt(int value) {
        this.stringBuilder.append((char)value);
    }

    @Override
    public String getResult() {
        return this.stringBuilder.toString();
    }

    public int length() {
        return this.stringBuilder.length();
    }

    public void clear() {
        this.stringBuilder.setLength(0);
    }
}

