/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.Level;
import io.jstuff.log.LogItem;
import io.jstuff.log.LogListener;
import io.jstuff.log.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LogList
extends LogListener
implements Iterable<LogItem> {
    private final List<LogItem> list = new ArrayList<LogItem>();
    private final String loggerName;

    public LogList(String loggerName) {
        this.loggerName = loggerName;
    }

    public LogList(Class<?> loggerClass) {
        this(loggerClass.getName());
    }

    public LogList() {
        this((String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receive(long time, Logger logger, Level level, Object message, Throwable throwable) {
        if (this.loggerName == null || this.loggerName.equals(logger.getName())) {
            List<LogItem> list = this.list;
            synchronized (list) {
                this.list.add(new LogItem(time, logger.getName(), level, message, throwable));
            }
        }
    }

    @Override
    public Iterator<LogItem> iterator() {
        return this.list.iterator();
    }

    public List<LogItem> toList() {
        return new ArrayList<LogItem>(this.list);
    }
}

