/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.AbstractLoggerFactory;
import io.jstuff.log.FormattingLoggerFactory;
import io.jstuff.log.GradleProxy;
import io.jstuff.log.JavaLogger;
import io.jstuff.log.Level;
import io.jstuff.log.Logger;
import io.jstuff.log.Slf4jLogger;
import io.jstuff.log.Slf4jProxy;
import io.jstuff.log.Slf4jProxyInterface;
import java.time.Clock;

public class DynamicLoggerFactory
extends AbstractLoggerFactory<Logger> {
    private static Slf4jProxyInterface slf4jProxy = null;
    private static boolean javaLogging = false;
    private FormattingLoggerFactory<?, ?> formattingLoggerFactory = null;

    public DynamicLoggerFactory(Level defaultLevel, Clock defaultClock) {
        super(defaultLevel, defaultClock);
    }

    public DynamicLoggerFactory(Level defaultLevel) {
        super(defaultLevel, systemClock);
    }

    public DynamicLoggerFactory(Clock defaultClock) {
        super(systemDefaultLevel, defaultClock);
    }

    public DynamicLoggerFactory() {
        super(systemDefaultLevel, systemClock);
    }

    public Logger getLogger(String name, Level level, Clock clock) {
        Object logger = this.getCachedLogger(name);
        if (logger != null) {
            return logger;
        }
        logger = this.getSpecificLogger(name, level, clock);
        this.putCachedLogger(name, logger);
        return logger;
    }

    private Logger getSpecificLogger(String name, Level level, Clock clock) {
        if (slf4jProxy != null) {
            try {
                return new Slf4jLogger(name, level, clock, slf4jProxy);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (javaLogging) {
            return new JavaLogger(name, level, clock);
        }
        return this.getFormattingLoggerFactory().getLogger(name, level, clock);
    }

    private synchronized FormattingLoggerFactory<?, ?> getFormattingLoggerFactory() {
        if (this.formattingLoggerFactory == null) {
            this.formattingLoggerFactory = FormattingLoggerFactory.getBasic();
        }
        return this.formattingLoggerFactory;
    }

    static {
        try {
            slf4jProxy = new GradleProxy();
        }
        catch (Exception ignore) {
            try {
                slf4jProxy = new Slf4jProxy();
            }
            catch (Exception ignore2) {
                javaLogging = System.getProperty("java.util.logging.config.file") != null || DynamicLoggerFactory.class.getResource("logging.properties") != null;
            }
        }
    }
}

