/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.log;

import io.jstuff.log.AbstractFormatter;
import io.jstuff.log.Level;
import java.time.ZoneId;

public class LogItem {
    private static final ZoneId defaultZoneId = ZoneId.systemDefault();
    private final long time;
    private final String name;
    private final Level level;
    private final Object message;
    private final Throwable throwable;

    public LogItem(long time, String name, Level level, Object message, Throwable throwable) {
        this.time = time;
        this.name = name;
        this.level = level;
        this.message = message;
        this.throwable = throwable;
    }

    public long getTime() {
        return this.time;
    }

    public String getName() {
        return this.name;
    }

    public Level getLevel() {
        return this.level;
    }

    public Object getMessage() {
        return this.message;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public String toString() {
        return this.toString(' ', defaultZoneId);
    }

    public String toString(char separator) {
        return this.toString(separator, defaultZoneId);
    }

    public String toString(ZoneId zoneId) {
        return this.toString(' ', zoneId);
    }

    public String toString(char separator, ZoneId zoneId) {
        StringBuilder sb = new StringBuilder();
        int dayMillis = AbstractFormatter.getDayMillis(this.time, zoneId);
        AbstractFormatter.outputTime(dayMillis, ch -> sb.append((char)ch));
        sb.append(separator);
        sb.append(this.name).append(separator);
        sb.append(this.level).append(separator);
        sb.append(this.message);
        if (this.throwable != null) {
            sb.append(separator).append(this.throwable.getClass().getName());
            sb.append(separator).append(this.throwable.getMessage());
        }
        return sb.toString();
    }
}

