/*
 * Decompiled with CFR 0.152.
 */
package io.jstuff.util;

import java.io.IOException;
import java.util.function.IntConsumer;

public class IntOutput {
    public static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] tensDigits = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
    public static final char[] digitsHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] digitsHexLC = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final String MIN_INTEGER_DIGITS = "2147483648";
    public static final String MIN_LONG_DIGITS = "9223372036854775808";

    public static void appendInt(Appendable a, int i) throws IOException {
        if (i < 0) {
            a.append('-');
            if (i == Integer.MIN_VALUE) {
                a.append(MIN_INTEGER_DIGITS);
            } else {
                IntOutput.appendPositiveInt(a, -i);
            }
        } else {
            IntOutput.appendPositiveInt(a, i);
        }
    }

    public static void appendPositiveInt(Appendable a, int i) throws IOException {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.appendPositiveInt(a, n);
            IntOutput.append2Digits(a, i - n * 100);
        } else if (i >= 10) {
            IntOutput.append2Digits(a, i);
        } else {
            a.append(digits[i]);
        }
    }

    public static void appendUnsignedInt(Appendable a, int i) throws IOException {
        if (i >= 0) {
            IntOutput.appendPositiveInt(a, i);
        } else {
            int n = (i >>> 1) / 50;
            IntOutput.appendPositiveInt(a, n);
            IntOutput.append2Digits(a, i - n * 100);
        }
    }

    public static void appendIntScaled(Appendable a, int i, int scale, char separator) throws IOException {
        if (i < 0) {
            a.append('-');
            if (i == Integer.MIN_VALUE) {
                IntOutput.appendStringScaled(a, MIN_INTEGER_DIGITS, scale, separator);
            } else {
                IntOutput.appendPositiveIntScaled(a, -i, scale, separator);
            }
        } else {
            IntOutput.appendPositiveIntScaled(a, i, scale, separator);
        }
    }

    private static void appendStringScaled(Appendable a, String string, int scale, char separator) throws IOException {
        if (scale <= 0) {
            a.append(string);
        } else {
            int length = string.length();
            if (scale >= length) {
                a.append('0');
                a.append(separator);
                for (int i = scale; i > length; --i) {
                    a.append('0');
                }
                a.append(string);
            } else {
                int insertionPoint = length - scale;
                for (int i = 0; i < length; ++i) {
                    if (i == insertionPoint) {
                        a.append(separator);
                    }
                    a.append(string.charAt(i));
                }
            }
        }
    }

    public static void appendPositiveIntScaled(Appendable a, int i, int scale, char separator) throws IOException {
        if (scale > 2) {
            int n = i / 100;
            IntOutput.appendPositiveIntScaled(a, n, scale - 2, separator);
            IntOutput.append2Digits(a, i - n * 100);
        } else if (scale == 2) {
            int n = i / 100;
            IntOutput.appendPositiveInt(a, n);
            a.append(separator);
            IntOutput.append2Digits(a, i - n * 100);
        } else if (scale == 1) {
            int n = i / 10;
            IntOutput.appendPositiveInt(a, n);
            a.append(separator);
            a.append(digits[i - n * 10]);
        } else if (i >= 100) {
            int n = i / 100;
            IntOutput.appendPositiveInt(a, n);
            IntOutput.append2Digits(a, i - n * 100);
        } else if (i >= 10) {
            IntOutput.append2Digits(a, i);
        } else {
            a.append(digits[i]);
        }
    }

    public static void appendLong(Appendable a, long n) throws IOException {
        if (n < 0L) {
            a.append('-');
            if (n == Long.MIN_VALUE) {
                a.append(MIN_LONG_DIGITS);
            } else {
                IntOutput.appendPositiveLong(a, -n);
            }
        } else {
            IntOutput.appendPositiveLong(a, n);
        }
    }

    public static void appendPositiveLong(Appendable a, long n) throws IOException {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.appendPositiveLong(a, m);
            IntOutput.append2Digits(a, (int)(n - m * 100L));
        } else {
            int i = (int)n;
            if (i >= 10) {
                a.append(tensDigits[i]);
            }
            a.append(digits[i]);
        }
    }

    public static void appendUnsignedLong(Appendable a, long n) throws IOException {
        if (n >= 0L) {
            IntOutput.appendPositiveLong(a, n);
        } else {
            long m = (n >>> 1) / 50L;
            IntOutput.appendPositiveLong(a, m);
            IntOutput.append2Digits(a, (int)(n - m * 100L));
        }
    }

    public static void appendLongScaled(Appendable a, long n, int scale, char separator) throws IOException {
        if (n < 0L) {
            a.append('-');
            if (n == Long.MIN_VALUE) {
                IntOutput.appendStringScaled(a, MIN_LONG_DIGITS, scale, separator);
            } else {
                IntOutput.appendPositiveLongScaled(a, -n, scale, separator);
            }
        } else {
            IntOutput.appendPositiveLongScaled(a, n, scale, separator);
        }
    }

    public static void appendPositiveLongScaled(Appendable a, long n, int scale, char separator) throws IOException {
        if (scale > 2) {
            long m = n / 100L;
            IntOutput.appendPositiveLongScaled(a, m, scale - 2, separator);
            IntOutput.append2Digits(a, (int)(n - m * 100L));
        } else if (scale == 2) {
            long m = n / 100L;
            IntOutput.appendPositiveLong(a, m);
            a.append(separator);
            IntOutput.append2Digits(a, (int)(n - m * 100L));
        } else if (scale == 1) {
            long m = n / 10L;
            IntOutput.appendPositiveLong(a, m);
            a.append(separator);
            a.append(digits[(int)(n - m * 10L)]);
        } else if (n >= 100L) {
            long m = n / 100L;
            IntOutput.appendPositiveLong(a, m);
            IntOutput.append2Digits(a, (int)(n - m * 100L));
        } else {
            int i = (int)n;
            if (i >= 10) {
                a.append(tensDigits[i]);
            }
            a.append(digits[i]);
        }
    }

    public static void append1Digit(Appendable a, int i) throws IOException {
        a.append((char)(i + 48));
    }

    public static void append1DigitSafe(Appendable a, int i) throws IOException {
        a.append(i == Integer.MIN_VALUE ? (char)'8' : (char)(Math.abs(i) % 10 + 48));
    }

    public static void append2Digits(Appendable a, int i) throws IOException {
        a.append(tensDigits[i]);
        a.append(digits[i]);
    }

    public static void append2DigitsSafe(Appendable a, int i) throws IOException {
        int n = i == Integer.MIN_VALUE ? 48 : Math.abs(i) % 100;
        a.append(tensDigits[n]);
        a.append(digits[n]);
    }

    public static void append3Digits(Appendable a, int i) throws IOException {
        int n = i / 100;
        a.append(digits[n]);
        IntOutput.append2Digits(a, i - n * 100);
    }

    public static void append3DigitsSafe(Appendable a, int i) throws IOException {
        int n = i == Integer.MIN_VALUE ? 648 : Math.abs(i) % 1000;
        int m = n / 100;
        a.append(digits[m]);
        IntOutput.append2Digits(a, n - m * 100);
    }

    public static void appendIntGrouped(Appendable a, int i, char groupingChar) throws IOException {
        if (i < 0) {
            a.append('-');
            if (i == Integer.MIN_VALUE) {
                a.append(MIN_INTEGER_DIGITS.charAt(0));
                a.append(groupingChar);
                a.append(MIN_INTEGER_DIGITS, 1, 4);
                a.append(groupingChar);
                a.append(MIN_INTEGER_DIGITS, 4, 7);
                a.append(groupingChar);
                a.append(MIN_INTEGER_DIGITS, 7, 10);
            } else {
                IntOutput.appendPositiveIntGrouped(a, -i, groupingChar);
            }
        } else {
            IntOutput.appendPositiveIntGrouped(a, i, groupingChar);
        }
    }

    public static void appendPositiveIntGrouped(Appendable a, int i, char groupingChar) throws IOException {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.appendPositiveIntGrouped1(a, n, groupingChar);
            IntOutput.append2Digits(a, i - n * 100);
        } else if (i >= 10) {
            IntOutput.append2Digits(a, i);
        } else {
            a.append(digits[i]);
        }
    }

    private static void appendPositiveIntGrouped1(Appendable a, int i, char groupingChar) throws IOException {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.appendPositiveIntGrouped2(a, n, groupingChar);
            a.append(tensDigits[i -= n * 100]);
            a.append(groupingChar);
            a.append(digits[i]);
        } else if (i >= 10) {
            a.append(tensDigits[i]);
            a.append(groupingChar);
            a.append(digits[i]);
        } else {
            a.append(digits[i]);
        }
    }

    private static void appendPositiveIntGrouped2(Appendable a, int i, char groupingChar) throws IOException {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.appendPositiveIntGrouped(a, n, groupingChar);
            a.append(groupingChar);
            IntOutput.append2Digits(a, i - n * 100);
        } else if (i >= 10) {
            IntOutput.append2Digits(a, i);
        } else {
            a.append(digits[i]);
        }
    }

    public static void appendLongGrouped(Appendable a, long n, char groupingChar) throws IOException {
        if (n < 0L) {
            a.append('-');
            if (n == Long.MIN_VALUE) {
                a.append(MIN_LONG_DIGITS.charAt(0));
                a.append(groupingChar);
                a.append(MIN_LONG_DIGITS, 1, 4);
                a.append(groupingChar);
                a.append(MIN_LONG_DIGITS, 4, 7);
                a.append(groupingChar);
                a.append(MIN_LONG_DIGITS, 7, 10);
                a.append(groupingChar);
                a.append(MIN_LONG_DIGITS, 10, 13);
                a.append(groupingChar);
                a.append(MIN_LONG_DIGITS, 13, 16);
                a.append(groupingChar);
                a.append(MIN_LONG_DIGITS, 16, 19);
            } else {
                IntOutput.appendPositiveLongGrouped(a, -n, groupingChar);
            }
        } else {
            IntOutput.appendPositiveLongGrouped(a, n, groupingChar);
        }
    }

    public static void appendPositiveLongGrouped(Appendable a, long n, char groupingChar) throws IOException {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.appendPositiveLongGrouped1(a, m, groupingChar);
            IntOutput.append2Digits(a, (int)(n - m * 100L));
        } else {
            int i = (int)n;
            if (i >= 10) {
                a.append(tensDigits[i]);
            }
            a.append(digits[i]);
        }
    }

    private static void appendPositiveLongGrouped1(Appendable a, long n, char groupingChar) throws IOException {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.appendPositiveLongGrouped2(a, m, groupingChar);
            int i = (int)(n - m * 100L);
            a.append(tensDigits[i]);
            a.append(groupingChar);
            a.append(digits[i]);
        } else {
            int i = (int)n;
            if (i >= 10) {
                a.append(tensDigits[i]);
                a.append(groupingChar);
            }
            a.append(digits[i]);
        }
    }

    private static void appendPositiveLongGrouped2(Appendable a, long n, char groupingChar) throws IOException {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.appendPositiveLongGrouped(a, m, groupingChar);
            a.append(groupingChar);
            IntOutput.append2Digits(a, (int)(n - m * 100L));
        } else {
            int i = (int)n;
            if (i >= 10) {
                a.append(tensDigits[i]);
            }
            a.append(digits[i]);
        }
    }

    public static void appendIntHex(Appendable a, int i) throws IOException {
        if ((i & 0xFFFF0000) != 0) {
            IntOutput.append16BitsHex(a, i >>> 16);
            IntOutput.append4Hex(a, i);
        } else {
            IntOutput.append16BitsHex(a, i);
        }
    }

    private static void append8BitsHex(Appendable a, int i) throws IOException {
        if ((i & 0xFFFFFFF0) != 0) {
            a.append(digitsHex[i >>> 4]);
        }
        a.append(digitsHex[i & 0xF]);
    }

    private static void append16BitsHex(Appendable a, int i) throws IOException {
        if ((i & 0xFFFFFF00) != 0) {
            IntOutput.append8BitsHex(a, i >>> 8);
            IntOutput.append2Hex(a, i);
        } else {
            IntOutput.append8BitsHex(a, i);
        }
    }

    public static void appendIntHexLC(Appendable a, int i) throws IOException {
        if ((i & 0xFFFF0000) != 0) {
            IntOutput.append16BitsHexLC(a, i >>> 16);
            IntOutput.append4HexLC(a, i);
        } else {
            IntOutput.append16BitsHexLC(a, i);
        }
    }

    private static void append8BitsHexLC(Appendable a, int i) throws IOException {
        if ((i & 0xFFFFFFF0) != 0) {
            a.append(digitsHexLC[i >>> 4]);
        }
        a.append(digitsHexLC[i & 0xF]);
    }

    private static void append16BitsHexLC(Appendable a, int i) throws IOException {
        if ((i & 0xFFFFFF00) != 0) {
            IntOutput.append8BitsHexLC(a, i >>> 8);
            IntOutput.append2HexLC(a, i);
        } else {
            IntOutput.append8BitsHexLC(a, i);
        }
    }

    public static void appendLongHex(Appendable a, long n) throws IOException {
        int hi = (int)(n >>> 32);
        int lo = (int)n;
        if (hi != 0) {
            IntOutput.appendIntHex(a, hi);
            IntOutput.append8Hex(a, lo);
        } else {
            IntOutput.appendIntHex(a, lo);
        }
    }

    public static void appendLongHexLC(Appendable a, long n) throws IOException {
        int hi = (int)(n >>> 32);
        int lo = (int)n;
        if (hi != 0) {
            IntOutput.appendIntHexLC(a, hi);
            IntOutput.append8HexLC(a, lo);
        } else {
            IntOutput.appendIntHexLC(a, lo);
        }
    }

    public static void append8Hex(Appendable a, int i) throws IOException {
        IntOutput.append4Hex(a, i >>> 16);
        IntOutput.append4Hex(a, i);
    }

    public static void append8HexLC(Appendable a, int i) throws IOException {
        IntOutput.append4HexLC(a, i >>> 16);
        IntOutput.append4HexLC(a, i);
    }

    public static void append4Hex(Appendable a, int i) throws IOException {
        IntOutput.append2Hex(a, i >>> 8);
        IntOutput.append2Hex(a, i);
    }

    public static void append4HexLC(Appendable a, int i) throws IOException {
        IntOutput.append2HexLC(a, i >>> 8);
        IntOutput.append2HexLC(a, i);
    }

    public static void append2Hex(Appendable a, int i) throws IOException {
        a.append(digitsHex[i >> 4 & 0xF]);
        a.append(digitsHex[i & 0xF]);
    }

    public static void append2HexLC(Appendable a, int i) throws IOException {
        a.append(digitsHexLC[i >> 4 & 0xF]);
        a.append(digitsHexLC[i & 0xF]);
    }

    public static void append1Hex(Appendable a, int i) throws IOException {
        a.append(digitsHex[i & 0xF]);
    }

    public static void append1HexLC(Appendable a, int i) throws IOException {
        a.append(digitsHexLC[i & 0xF]);
    }

    public static void outputInt(int i, IntConsumer consumer) {
        if (i < 0) {
            consumer.accept(45);
            if (i == Integer.MIN_VALUE) {
                IntOutput.outputString(MIN_INTEGER_DIGITS, consumer);
            } else {
                IntOutput.outputPositiveInt(-i, consumer);
            }
        } else {
            IntOutput.outputPositiveInt(i, consumer);
        }
    }

    public static void outputPositiveInt(int i, IntConsumer consumer) {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.outputPositiveInt(n, consumer);
            IntOutput.output2Digits(i - n * 100, consumer);
        } else if (i >= 10) {
            IntOutput.output2Digits(i, consumer);
        } else {
            consumer.accept(digits[i]);
        }
    }

    public static void outputUnsignedInt(int i, IntConsumer consumer) {
        if (i >= 0) {
            IntOutput.outputPositiveInt(i, consumer);
        } else {
            int n = (i >>> 1) / 50;
            IntOutput.outputPositiveInt(n, consumer);
            IntOutput.output2Digits(i - n * 100, consumer);
        }
    }

    public static void outputIntScaled(int i, int scale, char separator, IntConsumer consumer) {
        if (i < 0) {
            consumer.accept(45);
            if (i == Integer.MIN_VALUE) {
                IntOutput.outputStringScaled(MIN_INTEGER_DIGITS, scale, separator, consumer);
            } else {
                IntOutput.outputPositiveIntScaled(-i, scale, separator, consumer);
            }
        } else {
            IntOutput.outputPositiveIntScaled(i, scale, separator, consumer);
        }
    }

    private static void outputStringScaled(String string, int scale, char separator, IntConsumer consumer) {
        if (scale <= 0) {
            IntOutput.outputString(string, consumer);
        } else {
            int length = string.length();
            if (scale >= length) {
                consumer.accept(48);
                consumer.accept(separator);
                for (int i = scale; i > length; --i) {
                    consumer.accept(48);
                }
                IntOutput.outputString(string, consumer);
            } else {
                int insertionPoint = length - scale;
                for (int i = 0; i < length; ++i) {
                    if (i == insertionPoint) {
                        consumer.accept(separator);
                    }
                    consumer.accept(string.charAt(i));
                }
            }
        }
    }

    public static void outputPositiveIntScaled(int i, int scale, char separator, IntConsumer consumer) {
        if (scale > 2) {
            int n = i / 100;
            IntOutput.outputPositiveIntScaled(n, scale - 2, separator, consumer);
            IntOutput.output2Digits(i - n * 100, consumer);
        } else if (scale == 2) {
            int n = i / 100;
            IntOutput.outputPositiveInt(n, consumer);
            consumer.accept(separator);
            IntOutput.output2Digits(i - n * 100, consumer);
        } else if (scale == 1) {
            int n = i / 10;
            IntOutput.outputPositiveInt(n, consumer);
            consumer.accept(separator);
            consumer.accept(digits[i - n * 10]);
        } else if (i >= 100) {
            int n = i / 100;
            IntOutput.outputPositiveInt(n, consumer);
            IntOutput.output2Digits(i - n * 100, consumer);
        } else if (i >= 10) {
            IntOutput.output2Digits(i, consumer);
        } else {
            consumer.accept(digits[i]);
        }
    }

    public static void outputLong(long n, IntConsumer consumer) {
        if (n < 0L) {
            consumer.accept(45);
            if (n == Long.MIN_VALUE) {
                IntOutput.outputString(MIN_LONG_DIGITS, consumer);
            } else {
                IntOutput.outputPositiveLong(-n, consumer);
            }
        } else {
            IntOutput.outputPositiveLong(n, consumer);
        }
    }

    public static void outputPositiveLong(long n, IntConsumer consumer) {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.outputPositiveLong(m, consumer);
            IntOutput.output2Digits((int)(n - m * 100L), consumer);
        } else {
            int i = (int)n;
            if (i >= 10) {
                consumer.accept(tensDigits[i]);
            }
            consumer.accept(digits[i]);
        }
    }

    public static void outputUnsignedLong(long n, IntConsumer consumer) {
        if (n >= 0L) {
            IntOutput.outputPositiveLong(n, consumer);
        } else {
            long m = (n >>> 1) / 50L;
            IntOutput.outputPositiveLong(m, consumer);
            IntOutput.output2Digits((int)(n - m * 100L), consumer);
        }
    }

    public static void outputLongScaled(long n, int scale, char separator, IntConsumer consumer) {
        if (n < 0L) {
            consumer.accept(45);
            if (n == Long.MIN_VALUE) {
                IntOutput.outputStringScaled(MIN_LONG_DIGITS, scale, separator, consumer);
            } else {
                IntOutput.outputPositiveLongScaled(-n, scale, separator, consumer);
            }
        } else {
            IntOutput.outputPositiveLongScaled(n, scale, separator, consumer);
        }
    }

    public static void outputPositiveLongScaled(long n, int scale, char separator, IntConsumer consumer) {
        if (scale > 2) {
            long m = n / 100L;
            IntOutput.outputPositiveLongScaled(m, scale - 2, separator, consumer);
            IntOutput.output2Digits((int)(n - m * 100L), consumer);
        } else if (scale == 2) {
            long m = n / 100L;
            IntOutput.outputPositiveLong(m, consumer);
            consumer.accept(separator);
            IntOutput.output2Digits((int)(n - m * 100L), consumer);
        } else if (scale == 1) {
            long m = n / 10L;
            IntOutput.outputPositiveLong(m, consumer);
            consumer.accept(separator);
            consumer.accept(digits[(int)(n - m * 10L)]);
        } else if (n >= 100L) {
            long m = n / 100L;
            IntOutput.outputPositiveLong(m, consumer);
            IntOutput.output2Digits((int)(n - m * 100L), consumer);
        } else {
            int i = (int)n;
            if (i >= 10) {
                consumer.accept(tensDigits[i]);
            }
            consumer.accept(digits[i]);
        }
    }

    public static void output1Digit(int i, IntConsumer consumer) {
        consumer.accept(i + 48);
    }

    public static void output1DigitSafe(int i, IntConsumer consumer) {
        consumer.accept(i == Integer.MIN_VALUE ? 56 : Math.abs(i) % 10 + 48);
    }

    public static void output2Digits(int i, IntConsumer consumer) {
        consumer.accept(tensDigits[i]);
        consumer.accept(digits[i]);
    }

    public static void output2DigitsSafe(int i, IntConsumer consumer) {
        int n = i == Integer.MIN_VALUE ? 48 : Math.abs(i) % 100;
        consumer.accept(tensDigits[n]);
        consumer.accept(digits[n]);
    }

    public static void output3Digits(int i, IntConsumer consumer) {
        int n = i / 100;
        consumer.accept(digits[n]);
        IntOutput.output2Digits(i - n * 100, consumer);
    }

    public static void output3DigitsSafe(int i, IntConsumer consumer) {
        int n = i == Integer.MIN_VALUE ? 648 : Math.abs(i) % 1000;
        int m = n / 100;
        consumer.accept(digits[m]);
        IntOutput.output2Digits(n - m * 100, consumer);
    }

    public static void outputIntGrouped(int i, char groupingChar, IntConsumer consumer) {
        if (i < 0) {
            consumer.accept(45);
            if (i == Integer.MIN_VALUE) {
                consumer.accept(MIN_INTEGER_DIGITS.charAt(0));
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_INTEGER_DIGITS, 1, 4, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_INTEGER_DIGITS, 4, 7, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_INTEGER_DIGITS, 7, 10, consumer);
            } else {
                IntOutput.outputPositiveIntGrouped(-i, groupingChar, consumer);
            }
        } else {
            IntOutput.outputPositiveIntGrouped(i, groupingChar, consumer);
        }
    }

    public static void outputPositiveIntGrouped(int i, char groupingChar, IntConsumer consumer) {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.outputPositiveIntGrouped1(n, groupingChar, consumer);
            IntOutput.output2Digits(i - n * 100, consumer);
        } else if (i >= 10) {
            IntOutput.output2Digits(i, consumer);
        } else {
            consumer.accept(digits[i]);
        }
    }

    private static void outputPositiveIntGrouped1(int i, char groupingChar, IntConsumer consumer) {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.outputPositiveIntGrouped2(n, groupingChar, consumer);
            consumer.accept(tensDigits[i -= n * 100]);
            consumer.accept(groupingChar);
            consumer.accept(digits[i]);
        } else if (i >= 10) {
            consumer.accept(tensDigits[i]);
            consumer.accept(groupingChar);
            consumer.accept(digits[i]);
        } else {
            consumer.accept(digits[i]);
        }
    }

    private static void outputPositiveIntGrouped2(int i, char groupingChar, IntConsumer consumer) {
        if (i >= 100) {
            int n = i / 100;
            IntOutput.outputPositiveIntGrouped(n, groupingChar, consumer);
            consumer.accept(groupingChar);
            IntOutput.output2Digits(i - n * 100, consumer);
        } else if (i >= 10) {
            IntOutput.output2Digits(i, consumer);
        } else {
            consumer.accept(digits[i]);
        }
    }

    public static void outputLongGrouped(long n, char groupingChar, IntConsumer consumer) {
        if (n < 0L) {
            consumer.accept(45);
            if (n == Long.MIN_VALUE) {
                consumer.accept(MIN_LONG_DIGITS.charAt(0));
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_LONG_DIGITS, 1, 4, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_LONG_DIGITS, 4, 7, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_LONG_DIGITS, 7, 10, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_LONG_DIGITS, 10, 13, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_LONG_DIGITS, 13, 16, consumer);
                consumer.accept(groupingChar);
                IntOutput.outputString(MIN_LONG_DIGITS, 16, 19, consumer);
            } else {
                IntOutput.outputPositiveLongGrouped(-n, groupingChar, consumer);
            }
        } else {
            IntOutput.outputPositiveLongGrouped(n, groupingChar, consumer);
        }
    }

    public static void outputPositiveLongGrouped(long n, char groupingChar, IntConsumer consumer) {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.outputPositiveLongGrouped1(m, groupingChar, consumer);
            IntOutput.output2Digits((int)(n - m * 100L), consumer);
        } else {
            int i = (int)n;
            if (i >= 10) {
                consumer.accept(tensDigits[i]);
            }
            consumer.accept(digits[i]);
        }
    }

    private static void outputPositiveLongGrouped1(long n, char groupingChar, IntConsumer consumer) {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.outputPositiveLongGrouped2(m, groupingChar, consumer);
            int i = (int)(n - m * 100L);
            consumer.accept(tensDigits[i]);
            consumer.accept(groupingChar);
            consumer.accept(digits[i]);
        } else {
            int i = (int)n;
            if (i >= 10) {
                consumer.accept(tensDigits[i]);
                consumer.accept(groupingChar);
            }
            consumer.accept(digits[i]);
        }
    }

    private static void outputPositiveLongGrouped2(long n, char groupingChar, IntConsumer consumer) {
        if (n >= 100L) {
            long m = n / 100L;
            IntOutput.outputPositiveLongGrouped(m, groupingChar, consumer);
            consumer.accept(groupingChar);
            IntOutput.output2Digits((int)(n - m * 100L), consumer);
        } else {
            int i = (int)n;
            if (i >= 10) {
                consumer.accept(tensDigits[i]);
            }
            consumer.accept(digits[i]);
        }
    }

    public static void outputIntHex(int i, IntConsumer consumer) {
        if ((i & 0xFFFF0000) != 0) {
            IntOutput.output16BitsHex(i >>> 16, consumer);
            IntOutput.output4Hex(i, consumer);
        } else {
            IntOutput.output16BitsHex(i, consumer);
        }
    }

    private static void output8BitsHex(int i, IntConsumer consumer) {
        if ((i & 0xFFFFFFF0) != 0) {
            consumer.accept(digitsHex[i >>> 4]);
        }
        consumer.accept(digitsHex[i & 0xF]);
    }

    private static void output16BitsHex(int i, IntConsumer consumer) {
        if ((i & 0xFFFFFF00) != 0) {
            IntOutput.output8BitsHex(i >>> 8, consumer);
            IntOutput.output2Hex(i, consumer);
        } else {
            IntOutput.output8BitsHex(i, consumer);
        }
    }

    public static void outputIntHexLC(int i, IntConsumer consumer) {
        if ((i & 0xFFFF0000) != 0) {
            IntOutput.output16BitsHexLC(i >>> 16, consumer);
            IntOutput.output4HexLC(i, consumer);
        } else {
            IntOutput.output16BitsHexLC(i, consumer);
        }
    }

    private static void output8BitsHexLC(int i, IntConsumer consumer) {
        if ((i & 0xFFFFFFF0) != 0) {
            consumer.accept(digitsHexLC[i >>> 4]);
        }
        consumer.accept(digitsHexLC[i & 0xF]);
    }

    private static void output16BitsHexLC(int i, IntConsumer consumer) {
        if ((i & 0xFFFFFF00) != 0) {
            IntOutput.output8BitsHexLC(i >>> 8, consumer);
            IntOutput.output2HexLC(i, consumer);
        } else {
            IntOutput.output8BitsHexLC(i, consumer);
        }
    }

    public static void outputLongHex(long n, IntConsumer consumer) {
        int hi = (int)(n >>> 32);
        int lo = (int)n;
        if (hi != 0) {
            IntOutput.outputIntHex(hi, consumer);
            IntOutput.output8Hex(lo, consumer);
        } else {
            IntOutput.outputIntHex(lo, consumer);
        }
    }

    public static void outputLongHexLC(long n, IntConsumer consumer) {
        int hi = (int)(n >>> 32);
        int lo = (int)n;
        if (hi != 0) {
            IntOutput.outputIntHexLC(hi, consumer);
            IntOutput.output8HexLC(lo, consumer);
        } else {
            IntOutput.outputIntHexLC(lo, consumer);
        }
    }

    public static void output8Hex(int i, IntConsumer consumer) {
        IntOutput.output4Hex(i >>> 16, consumer);
        IntOutput.output4Hex(i, consumer);
    }

    public static void output8HexLC(int i, IntConsumer consumer) {
        IntOutput.output4HexLC(i >>> 16, consumer);
        IntOutput.output4HexLC(i, consumer);
    }

    public static void output4Hex(int i, IntConsumer consumer) {
        IntOutput.output2Hex(i >> 8, consumer);
        IntOutput.output2Hex(i, consumer);
    }

    public static void output4HexLC(int i, IntConsumer consumer) {
        IntOutput.output2HexLC(i >> 8, consumer);
        IntOutput.output2HexLC(i, consumer);
    }

    public static void output2Hex(int i, IntConsumer consumer) {
        consumer.accept(digitsHex[i >> 4 & 0xF]);
        consumer.accept(digitsHex[i & 0xF]);
    }

    public static void output2HexLC(int i, IntConsumer consumer) {
        consumer.accept(digitsHexLC[i >> 4 & 0xF]);
        consumer.accept(digitsHexLC[i & 0xF]);
    }

    public static void output1Hex(int i, IntConsumer consumer) {
        consumer.accept(digitsHex[i & 0xF]);
    }

    public static void output1HexLC(int i, IntConsumer consumer) {
        consumer.accept(digitsHexLC[i & 0xF]);
    }

    private static void outputString(String s, int start, int end, IntConsumer consumer) {
        for (int i = start; i < end; ++i) {
            consumer.accept(s.charAt(i));
        }
    }

    private static void outputString(String s, IntConsumer consumer) {
        IntOutput.outputString(s, 0, s.length(), consumer);
    }
}

