/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.compression;

import io.jsonwebtoken.impl.compression.AbstractCompressionCodec;
import io.jsonwebtoken.lang.Objects;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;

public class DeflateCompressionCodec
extends AbstractCompressionCodec {
    private static final String DEFLATE = "DEF";

    @Override
    public String getAlgorithmName() {
        return DEFLATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] doCompress(byte[] payload) throws IOException {
        byte[] byArray;
        Deflater deflater = new Deflater(9);
        ByteArrayOutputStream outputStream = null;
        DeflaterOutputStream deflaterOutputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            deflaterOutputStream = new DeflaterOutputStream((OutputStream)outputStream, deflater, true);
            deflaterOutputStream.write(payload, 0, payload.length);
            deflaterOutputStream.flush();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(outputStream, deflaterOutputStream);
            throw throwable;
        }
        Objects.nullSafeClose(outputStream, deflaterOutputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] doDecompress(byte[] compressed) throws IOException {
        byte[] byArray;
        InflaterOutputStream inflaterOutputStream = null;
        ByteArrayOutputStream decompressedOutputStream = null;
        try {
            decompressedOutputStream = new ByteArrayOutputStream();
            inflaterOutputStream = new InflaterOutputStream(decompressedOutputStream);
            inflaterOutputStream.write(compressed);
            inflaterOutputStream.flush();
            byArray = decompressedOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(decompressedOutputStream, inflaterOutputStream);
            throw throwable;
        }
        Objects.nullSafeClose(decompressedOutputStream, inflaterOutputStream);
        return byArray;
    }
}

