/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.crypto;

import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.impl.crypto.RsaProvider;
import io.jsonwebtoken.impl.crypto.RsaSigner;
import io.jsonwebtoken.impl.crypto.SignatureValidator;
import io.jsonwebtoken.lang.Assert;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Arrays;

public class RsaSignatureValidator
extends RsaProvider
implements SignatureValidator {
    public RsaSignatureValidator(SignatureAlgorithm alg, Key key) {
        super(alg, key);
        Assert.isTrue(key instanceof PrivateKey || key instanceof PublicKey, "RSA Signature validation requires either a PublicKey or PrivateKey instance.");
    }

    @Override
    public boolean isValid(byte[] data, byte[] signature) {
        if (this.key instanceof PublicKey) {
            Signature sig = this.createSignatureInstance();
            PublicKey publicKey = (PublicKey)this.key;
            try {
                sig.initVerify(publicKey);
                sig.update(data);
                return sig.verify(signature);
            }
            catch (Exception e) {
                String msg = "Unable to verify RSA signature using configured PublicKey.  " + e.getMessage();
                throw new SignatureException(msg, e);
            }
        }
        byte[] computed = new RsaSigner(this.alg, this.key).sign(data);
        return Arrays.equals(computed, signature);
    }
}

