/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.orgjson.io;

import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.io.SerializationException;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.lang.Classes;
import io.jsonwebtoken.lang.Collections;
import io.jsonwebtoken.lang.DateFormats;
import io.jsonwebtoken.lang.Objects;
import io.jsonwebtoken.lang.Strings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class OrgJsonSerializer<T>
implements Serializer<T> {
    private static final String JSON_WRITER_CLASS_NAME = "org.json.JSONWriter";
    private static final Class[] VALUE_TO_STRING_ARG_TYPES = new Class[]{Object.class};
    private static final String JSON_STRING_CLASS_NAME = "org.json.JSONString";
    private static final Class JSON_STRING_CLASS = Classes.isAvailable((String)"org.json.JSONString") ? Classes.forName((String)"org.json.JSONString") : null;

    public byte[] serialize(T t) throws SerializationException {
        try {
            Object o = this.toJSONInstance(t);
            return this.toBytes(o);
        }
        catch (SerializationException se) {
            throw se;
        }
        catch (Exception e) {
            String msg = "Unable to serialize object of type " + t.getClass().getName() + " to JSON: " + e.getMessage();
            throw new SerializationException(msg, (Throwable)e);
        }
    }

    private static boolean isJSONString(Object o) {
        if (JSON_STRING_CLASS != null) {
            return JSON_STRING_CLASS.isInstance(o);
        }
        return false;
    }

    private Object toJSONInstance(Object object) {
        if (object == null) {
            return JSONObject.NULL;
        }
        if (object instanceof JSONObject || object instanceof JSONArray || JSONObject.NULL.equals(object) || OrgJsonSerializer.isJSONString(object) || object instanceof Byte || object instanceof Character || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String || object instanceof BigInteger || object instanceof BigDecimal || object instanceof Enum) {
            return object;
        }
        if (object instanceof Calendar) {
            object = ((Calendar)object).getTime();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return DateFormats.formatIso8601((Date)date);
        }
        if (object instanceof byte[]) {
            return Encoders.BASE64.encode((Object)((byte[])object));
        }
        if (object instanceof char[]) {
            return new String((char[])object);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return this.toJSONObject(map);
        }
        if (object instanceof Collection) {
            Collection coll = (Collection)object;
            return this.toJSONArray(coll);
        }
        if (Objects.isArray((Object)object)) {
            List c = Collections.arrayToList((Object)object);
            return this.toJSONArray(c);
        }
        String msg = "Unable to serialize object of type " + object.getClass().getName() + " to JSON using known heuristics.";
        throw new SerializationException(msg);
    }

    private JSONObject toJSONObject(Map<?, ?> m) {
        JSONObject obj = new JSONObject();
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            Object k = entry.getKey();
            Object value = entry.getValue();
            String key = String.valueOf(k);
            value = this.toJSONInstance(value);
            obj.put(key, value);
        }
        return obj;
    }

    private JSONArray toJSONArray(Collection c) {
        JSONArray array = new JSONArray();
        for (Object o : c) {
            o = this.toJSONInstance(o);
            array.put(o);
        }
        return array;
    }

    protected byte[] toBytes(Object o) {
        String s = o instanceof JSONObject ? o.toString() : (String)Classes.invokeStatic((String)JSON_WRITER_CLASS_NAME, (String)"valueToString", (Class[])VALUE_TO_STRING_ARG_TYPES, (Object[])new Object[]{o});
        return s.getBytes(Strings.UTF_8);
    }
}

