/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.runtime;

import io.joynr.guice.LowerCaseProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyLoader {
    private static Logger logger = LoggerFactory.getLogger(PropertyLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<InputStream> loadResource(String resourceName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(resourceName);
        if (url != null) {
            InputStream urlStream = null;
            try {
                urlStream = url.openStream();
                Optional<InputStream> optional = Optional.of(urlStream);
                return optional;
            }
            catch (IOException iOException) {
            }
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(resourceName);
            Optional<InputStream> optional = Optional.ofNullable(fileInputStream);
            return optional;
        }
        catch (IOException iOException) {
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(String fileName) {
        LowerCaseProperties properties = new LowerCaseProperties();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL url = classLoader.getResource(fileName);
        if (url != null) {
            InputStream urlStream = null;
            try {
                urlStream = url.openStream();
                properties.load(urlStream);
                logger.info("Properties from classpath loaded file {}", (Object)fileName);
            }
            catch (IOException e) {
                logger.info("Properties from classpath file {} could not be loaded. Error:", (Object)fileName, (Object)e);
            }
            finally {
                if (urlStream != null) {
                    try {
                        urlStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        LowerCaseProperties propertiesFromFileSystem = PropertyLoader.loadProperties(new File(fileName));
        properties.putAll((Map)propertiesFromFileSystem);
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LowerCaseProperties loadProperties(File file) {
        LowerCaseProperties properties = new LowerCaseProperties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            properties.load((InputStream)fileInputStream);
            logger.info("Properties from runtime directory loaded file: {}", (Object)file.getAbsolutePath());
        }
        catch (IOException e) {
            logger.info("Properties from runtime directory not loaded because: {}", (Object)e.getMessage());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return properties;
    }

    public static Properties loadProperties(Properties properties, String fileName) {
        properties.putAll((Map<?, ?>)PropertyLoader.loadProperties(fileName));
        return properties;
    }

    public static Properties getPropertiesWithPattern(Properties originalProperties, String regex) {
        Properties properties = new Properties();
        Enumeration<Object> keys = originalProperties.keys();
        while (keys.hasMoreElements()) {
            String nextKey = (String)keys.nextElement();
            if (!Pattern.compile(regex).matcher(nextKey).find()) continue;
            properties.put(nextKey.replace("_", "."), originalProperties.getProperty(nextKey));
        }
        return properties;
    }
}

