/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.joynr.capabilities.CapabilitiesProvisioning;
import io.joynr.capabilities.CapabilityUtils;
import io.joynr.capabilities.LegacyCapabilitiesProvisioning;
import io.joynr.capabilities.ResourceContentProvider;
import io.joynr.exceptions.JoynrRuntimeException;
import io.joynr.messaging.inprocess.InProcessAddress;
import io.joynr.messaging.routing.RoutingTable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import joynr.infrastructure.GlobalCapabilitiesDirectory;
import joynr.infrastructure.GlobalDomainAccessController;
import joynr.system.RoutingTypes.Address;
import joynr.system.RoutingTypes.ChannelAddress;
import joynr.system.RoutingTypes.MqttAddress;
import joynr.types.DiscoveryEntry;
import joynr.types.GlobalDiscoveryEntry;
import joynr.types.ProviderScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticCapabilitiesProvisioning
implements CapabilitiesProvisioning {
    public static final String PROPERTY_PROVISIONED_CAPABILITIES_FILE = "joynr.capabilities.provisioned.file";
    private static Logger logger = LoggerFactory.getLogger(StaticCapabilitiesProvisioning.class);
    private final ResourceContentProvider resourceContentProvider;
    private Collection<DiscoveryEntry> discoveryEntries = new HashSet<DiscoveryEntry>();

    @Inject
    public StaticCapabilitiesProvisioning(@Named(value="joynr.capabilities.provisioned.file") String provisionedCapabilitiesFile, @Named(value="joynr.messaging.channelid") String localChannelId, ObjectMapper objectMapper, RoutingTable routingTable, LegacyCapabilitiesProvisioning legacyCapabilitiesProvisioning, ResourceContentProvider resourceContentProvider) {
        this.resourceContentProvider = resourceContentProvider;
        this.addEntriesFromJson(provisionedCapabilitiesFile, objectMapper, localChannelId);
        logger.trace("{} provisioned discovery entries loaded from JSON: {}", (Object)this.discoveryEntries.size(), this.discoveryEntries);
        this.overrideEntriesFromLegacySettings(legacyCapabilitiesProvisioning);
        logger.trace("{} provisioned discovery entries after adding legacy entries: {}", (Object)this.discoveryEntries.size(), this.discoveryEntries);
        logger.debug("Statically provisioned discovery entries loaded: {}", this.discoveryEntries);
        this.addAddressesToRoutingTable(routingTable);
    }

    private void addAddressesToRoutingTable(RoutingTable routingTable) {
        for (DiscoveryEntry discoveryEntry : this.discoveryEntries) {
            if (!(discoveryEntry instanceof GlobalDiscoveryEntry)) continue;
            GlobalDiscoveryEntry globalDiscoveryEntry = (GlobalDiscoveryEntry)discoveryEntry;
            boolean isGloballyVisible = globalDiscoveryEntry.getQos().getScope() == ProviderScope.GLOBAL;
            long expiryDateMs = Long.MAX_VALUE;
            boolean isSticky = true;
            boolean allowUpdate = false;
            routingTable.put(globalDiscoveryEntry.getParticipantId(), CapabilityUtils.getAddressFromGlobalDiscoveryEntry(globalDiscoveryEntry), isGloballyVisible, Long.MAX_VALUE, true, false);
        }
    }

    private void overrideEntriesFromLegacySettings(LegacyCapabilitiesProvisioning legacyCapabilitiesProvisioning) {
        DiscoveryEntry domainAccessControllerEntry;
        DiscoveryEntry globalCapabilitiesEntry = legacyCapabilitiesProvisioning.getDiscoveryEntryForInterface(GlobalCapabilitiesDirectory.class);
        if (globalCapabilitiesEntry != null) {
            this.removeExistingEntryForInterface("infrastructure/GlobalCapabilitiesDirectory");
            this.discoveryEntries.add(globalCapabilitiesEntry);
        }
        if ((domainAccessControllerEntry = legacyCapabilitiesProvisioning.getDiscoveryEntryForInterface(GlobalDomainAccessController.class)) != null) {
            this.removeExistingEntryForInterface("infrastructure/GlobalDomainAccessController");
            this.discoveryEntries.add(domainAccessControllerEntry);
        }
    }

    private void removeExistingEntryForInterface(String interfaceName) {
        DiscoveryEntry entryToRemove = null;
        for (DiscoveryEntry discoveryEntry : this.discoveryEntries) {
            if (!(discoveryEntry instanceof GlobalDiscoveryEntry) || !interfaceName.equals(((GlobalDiscoveryEntry)discoveryEntry).getInterfaceName())) continue;
            entryToRemove = discoveryEntry;
            break;
        }
        if (entryToRemove != null) {
            this.discoveryEntries.remove(entryToRemove);
        }
    }

    private void addEntriesFromJson(String provisionedCapabilitiesJsonFilename, ObjectMapper objectMapper, String localChannelId) {
        String provisionedCapabilitiesJsonString = this.resourceContentProvider.readFromFileOrResourceOrUrl(provisionedCapabilitiesJsonFilename);
        logger.trace("Statically provisioned capabilities JSON read: {}", (Object)provisionedCapabilitiesJsonString);
        List newEntries = null;
        try {
            newEntries = (List)objectMapper.readValue(provisionedCapabilitiesJsonString, (TypeReference)new TypeReference<List<GlobalDiscoveryEntry>>(){});
            for (GlobalDiscoveryEntry globalDiscoveryEntry : newEntries) {
                globalDiscoveryEntry.setLastSeenDateMs(Long.valueOf(System.currentTimeMillis()));
                Address address = CapabilityUtils.getAddressFromGlobalDiscoveryEntry(globalDiscoveryEntry);
                this.substituteInProcessAddressIfLocal(objectMapper, localChannelId, globalDiscoveryEntry, address);
                this.discoveryEntries.add((DiscoveryEntry)globalDiscoveryEntry);
            }
        }
        catch (IOException e) {
            String message = String.format("Unable to load provisioned capabilities. Invalid JSON value: %s", provisionedCapabilitiesJsonString);
            throw new JoynrRuntimeException(message, (Throwable)e);
        }
    }

    private void substituteInProcessAddressIfLocal(ObjectMapper objectMapper, String localChannelId, GlobalDiscoveryEntry globalDiscoveryEntry, Address address) throws JsonProcessingException {
        if (address instanceof ChannelAddress && localChannelId.equals(((ChannelAddress)address).getChannelId()) || address instanceof MqttAddress && localChannelId.equals(((MqttAddress)address).getTopic())) {
            InProcessAddress localAddress = new InProcessAddress();
            globalDiscoveryEntry.setAddress(objectMapper.writeValueAsString((Object)localAddress));
        }
    }

    @Override
    public Collection<DiscoveryEntry> getDiscoveryEntries() {
        return this.discoveryEntries;
    }
}

