/*
 * Decompiled with CFR 0.152.
 */
package io.joynr.capabilities;

import com.google.inject.Provider;
import io.joynr.capabilities.CapabilitiesProvisioning;
import io.joynr.exceptions.JoynrRuntimeException;
import joynr.types.DiscoveryEntry;
import joynr.types.GlobalDiscoveryEntry;

public abstract class AbstractGlobalDiscoveryEntryProvider
implements Provider<GlobalDiscoveryEntry> {
    private final CapabilitiesProvisioning capabilitiesProvisioning;
    private final String interfaceName;

    public AbstractGlobalDiscoveryEntryProvider(CapabilitiesProvisioning capabilitiesProvisioning, String interfaceName) {
        assert (capabilitiesProvisioning != null) : "Capabilities provisioning must not be null.";
        assert (interfaceName != null) : "Interface name must not be null.";
        this.capabilitiesProvisioning = capabilitiesProvisioning;
        this.interfaceName = interfaceName;
    }

    public GlobalDiscoveryEntry get() {
        GlobalDiscoveryEntry result = null;
        for (DiscoveryEntry discoveryEntry : this.capabilitiesProvisioning.getDiscoveryEntries()) {
            GlobalDiscoveryEntry globalDiscoveryEntry;
            if (!(discoveryEntry instanceof GlobalDiscoveryEntry) || !this.interfaceName.equals((globalDiscoveryEntry = (GlobalDiscoveryEntry)discoveryEntry).getInterfaceName())) continue;
            if (result != null) {
                throw new JoynrRuntimeException("Duplicate discovery entry for " + this.interfaceName + ". Make sure only one capability is provisioned for that interface.");
            }
            result = globalDiscoveryEntry;
        }
        if (result == null) {
            throw new JoynrRuntimeException("No discovery entry provisioned for capability " + this.interfaceName + ". Exactly one must be provisioned.");
        }
        return result;
    }
}

