/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.netty;

import com.typesafe.config.Config;
import io.jooby.Body;
import io.jooby.ByteRange;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.DefaultContext;
import io.jooby.FileUpload;
import io.jooby.Formdata;
import io.jooby.MediaType;
import io.jooby.Multipart;
import io.jooby.QueryString;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.Sender;
import io.jooby.Server;
import io.jooby.Session;
import io.jooby.SessionStore;
import io.jooby.SneakyThrows;
import io.jooby.StatusCode;
import io.jooby.Value;
import io.jooby.ValueNode;
import io.jooby.WebSocket;
import io.jooby.WebSocketConfigurer;
import io.jooby.internal.netty.NettyBody;
import io.jooby.internal.netty.NettyFileUpload;
import io.jooby.internal.netty.NettyOutputStream;
import io.jooby.internal.netty.NettySender;
import io.jooby.internal.netty.NettyWebSocket;
import io.jooby.internal.netty.NettyWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.handler.codec.http.websocketx.WebSocketDecoderConfig;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.stream.ChunkedNioStream;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class NettyContext
implements DefaultContext,
ChannelFutureListener {
    private static final HttpHeaders NO_TRAILING = EmptyHttpHeaders.INSTANCE;
    final DefaultHttpHeaders setHeaders = new DefaultHttpHeaders(true);
    private final int bufferSize;
    InterfaceHttpPostRequestDecoder decoder;
    private Router router;
    private Route route;
    ChannelHandlerContext ctx;
    private HttpRequest req;
    private String path;
    private HttpResponseStatus status = HttpResponseStatus.OK;
    private boolean responseStarted;
    private QueryString query;
    private Formdata form;
    private Multipart multipart;
    private List<FileUpload> files;
    private ValueNode headers;
    private Map<String, String> pathMap = Collections.EMPTY_MAP;
    private MediaType responseType;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private long contentLength = -1L;
    private boolean needsFlush;
    private Map<String, String> cookies;
    private Map<String, String> responseCookies;
    private Boolean resetHeadersOnError;
    NettyWebSocket webSocket;

    public NettyContext(ChannelHandlerContext ctx, HttpRequest req, Router router, String path, int bufferSize) {
        this.path = path;
        this.ctx = ctx;
        this.req = req;
        this.router = router;
        this.bufferSize = bufferSize;
    }

    @Nonnull
    public Router getRouter() {
        return this.router;
    }

    @Nonnull
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nonnull
    public String getMethod() {
        return this.req.method().asciiName().toUpperCase().toString();
    }

    @Nonnull
    public Route getRoute() {
        return this.route;
    }

    @Nonnull
    public Context setRoute(@Nonnull Route route) {
        this.route = route;
        return this;
    }

    @Nonnull
    public final String pathString() {
        return this.path;
    }

    @Nonnull
    public Map<String, String> pathMap() {
        return this.pathMap;
    }

    @Nonnull
    public Context setPathMap(@Nonnull Map<String, String> pathMap) {
        this.pathMap = pathMap;
        return this;
    }

    public final boolean isInIoThread() {
        return this.ctx.channel().eventLoop().inEventLoop();
    }

    @Nonnull
    public Context dispatch(@Nonnull Runnable action) {
        return this.dispatch(this.router.getWorker(), action);
    }

    public Context dispatch(Executor executor, Runnable action) {
        executor.execute(action);
        return this;
    }

    @Nonnull
    public Context detach(@Nonnull Route.Handler next) throws Exception {
        next.apply((Context)this);
        return this;
    }

    @Nonnull
    public QueryString query() {
        if (this.query == null) {
            String uri = this.req.uri();
            int q = uri.indexOf(63);
            this.query = QueryString.create((Context)this, q >= 0 ? uri.substring(q + 1) : null);
        }
        return this.query;
    }

    @Nonnull
    public Formdata form() {
        if (this.form == null) {
            this.form = Formdata.create((Context)this);
            this.decodeForm(this.req, this.form);
        }
        return this.form;
    }

    @Nonnull
    public Multipart multipart() {
        if (this.multipart == null) {
            this.multipart = Multipart.create((Context)this);
            this.form = this.multipart;
            this.decodeForm(this.req, (Formdata)this.multipart);
        }
        return this.multipart;
    }

    @Nonnull
    public Value header(@Nonnull String name) {
        return Value.create((Context)this, (String)name, (List)this.req.headers().getAll(name));
    }

    @Nonnull
    public String getRemoteAddress() {
        InetSocketAddress remoteAddress = (InetSocketAddress)this.ctx.channel().remoteAddress();
        return remoteAddress.getAddress().getHostAddress();
    }

    @Nonnull
    public String getProtocol() {
        return this.req.protocolVersion().text();
    }

    @Nonnull
    public String getScheme() {
        return "http";
    }

    @Nonnull
    public ValueNode header() {
        if (this.headers == null) {
            LinkedHashMap<String, List> headerMap = new LinkedHashMap<String, List>();
            HttpHeaders headers = this.req.headers();
            Set names = headers.names();
            for (String name : names) {
                headerMap.put(name, headers.getAll(name));
            }
            this.headers = Value.hash((Context)this, headerMap);
        }
        return this.headers;
    }

    @Nonnull
    public Body body() {
        if (this.decoder != null && this.decoder.hasNext()) {
            return new NettyBody((Context)this, (HttpData)this.decoder.next(), HttpUtil.getContentLength((HttpMessage)this.req, (long)-1L));
        }
        return Body.empty((Context)this);
    }

    @Nonnull
    public Map<String, String> cookieMap() {
        if (this.cookies == null) {
            Set cookies;
            this.cookies = Collections.emptyMap();
            String cookieString = this.req.headers().get((CharSequence)HttpHeaderNames.COOKIE);
            if (cookieString != null && (cookies = ServerCookieDecoder.STRICT.decode(cookieString)).size() > 0) {
                this.cookies = new LinkedHashMap<String, String>(cookies.size());
                for (io.netty.handler.codec.http.cookie.Cookie it : cookies) {
                    this.cookies.put(it.name(), it.value());
                }
            }
        }
        return this.cookies;
    }

    @Nonnull
    public Context upgrade(WebSocket.Initializer handler) {
        try {
            long timeout;
            this.responseStarted = true;
            String webSocketURL = this.getProtocol() + "://" + this.req.headers().get((CharSequence)HttpHeaderNames.HOST) + this.path;
            WebSocketDecoderConfig config = WebSocketDecoderConfig.newBuilder().allowExtensions(true).allowMaskMismatch(false).withUTF8Validator(false).maxFramePayloadLength(131072).build();
            this.webSocket = new NettyWebSocket(this);
            handler.init(Context.readOnly((Context)this), (WebSocketConfigurer)this.webSocket);
            DefaultFullHttpRequest fullHttpRequest = new DefaultFullHttpRequest(this.req.protocolVersion(), this.req.method(), this.req.uri(), Unpooled.EMPTY_BUFFER, this.req.headers(), (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(webSocketURL, null, config);
            WebSocketServerHandshaker handshaker = factory.newHandshaker((HttpRequest)fullHttpRequest);
            handshaker.handshake(this.ctx.channel(), (FullHttpRequest)fullHttpRequest, (HttpHeaders)this.setHeaders, this.ctx.newPromise()).addListener(future -> {
                if (future.isSuccess()) {
                    this.webSocket.fireConnect();
                }
            });
            Config conf = this.getRouter().getConfig();
            long l = timeout = conf.hasPath("websocket.idleTimeout") ? conf.getDuration("websocket.idleTimeout", TimeUnit.MINUTES) : 5L;
            if (timeout > 0L) {
                IdleStateHandler idle = new IdleStateHandler(timeout, 0L, 0L, TimeUnit.MINUTES);
                this.ctx.pipeline().addBefore("handler", "idle", (ChannelHandler)idle);
            }
        }
        catch (Throwable x) {
            this.sendError(x);
        }
        return this;
    }

    @Nonnull
    public StatusCode getResponseCode() {
        return StatusCode.valueOf((int)this.status.code());
    }

    @Nonnull
    public Context setResponseCode(int statusCode) {
        this.status = HttpResponseStatus.valueOf((int)statusCode);
        return this;
    }

    @Nonnull
    public Context setResponseHeader(@Nonnull String name, @Nonnull String value) {
        this.setHeaders.set(name, (Object)value);
        return this;
    }

    @Nonnull
    public Context removeResponseHeader(@Nonnull String name) {
        this.setHeaders.remove(name);
        return this;
    }

    @Nonnull
    public Context removeResponseHeaders() {
        this.setHeaders.clear();
        return this;
    }

    @Nonnull
    public MediaType getResponseType() {
        return this.responseType == null ? MediaType.text : this.responseType;
    }

    @Nonnull
    public Context setDefaultResponseType(@Nonnull MediaType contentType) {
        if (this.responseType == null) {
            this.setResponseType(contentType, contentType.getCharset());
        }
        return this;
    }

    public final Context setResponseType(MediaType contentType, Charset charset) {
        this.responseType = contentType;
        this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType.toContentTypeHeader(charset));
        return this;
    }

    @Nonnull
    public Context setResponseType(@Nonnull String contentType) {
        this.responseType = MediaType.valueOf((String)contentType);
        this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        return this;
    }

    @Nonnull
    public Context setResponseLength(long length) {
        this.contentLength = length;
        this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Long.toString(length));
        return this;
    }

    public long getResponseLength() {
        return this.contentLength;
    }

    @Nonnull
    public Context setResponseCookie(@Nonnull Cookie cookie) {
        if (this.responseCookies == null) {
            this.responseCookies = new HashMap<String, String>();
        }
        cookie.setPath(cookie.getPath(this.getContextPath()));
        this.responseCookies.put(cookie.getName(), cookie.toCookieString());
        this.setHeaders.remove((CharSequence)HttpHeaderNames.SET_COOKIE);
        for (String cookieString : this.responseCookies.values()) {
            this.setHeaders.add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)cookieString);
        }
        return this;
    }

    @Nonnull
    public PrintWriter responseWriter(MediaType type, Charset charset) {
        this.responseStarted = true;
        this.setResponseType(type, charset);
        return new PrintWriter(new NettyWriter(this.newOutputStream(), charset));
    }

    @Nonnull
    public Sender responseSender() {
        this.responseStarted = true;
        this.prepareChunked();
        this.ctx.write((Object)new DefaultHttpResponse(this.req.protocolVersion(), this.status, (HttpHeaders)this.setHeaders));
        return new NettySender(this, this.ctx);
    }

    @Nonnull
    public OutputStream responseStream() {
        return this.newOutputStream();
    }

    @Nonnull
    public Context send(@Nonnull String data) {
        return this.send(Unpooled.copiedBuffer((CharSequence)data, (Charset)StandardCharsets.UTF_8));
    }

    public final Context send(String data, Charset charset) {
        return this.send(Unpooled.copiedBuffer((CharSequence)data, (Charset)charset));
    }

    public final Context send(byte[] data) {
        return this.send(Unpooled.wrappedBuffer((byte[])data));
    }

    @Nonnull
    public Context send(byte[] ... data) {
        return this.send(Unpooled.wrappedBuffer((byte[][])data));
    }

    @Nonnull
    public Context send(@Nonnull ByteBuffer[] data) {
        return this.send(Unpooled.wrappedBuffer((ByteBuffer[])data));
    }

    public final Context send(ByteBuffer data) {
        return this.send(Unpooled.wrappedBuffer((ByteBuffer)data));
    }

    private Context send(@Nonnull ByteBuf data) {
        this.responseStarted = true;
        this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Long.toString(data.readableBytes()));
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, this.status, data, (HttpHeaders)this.setHeaders, NO_TRAILING);
        if (this.ctx.channel().eventLoop().inEventLoop()) {
            this.needsFlush = true;
            this.ctx.write((Object)response).addListener((GenericFutureListener)this);
        } else {
            this.ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)this);
        }
        return this;
    }

    public void flush() {
        if (this.needsFlush) {
            this.needsFlush = false;
            this.ctx.flush();
        }
    }

    @Nonnull
    public Context send(@Nonnull ReadableByteChannel channel) {
        this.prepareChunked();
        DefaultHttpResponse rsp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.status, (HttpHeaders)this.setHeaders);
        this.responseStarted = true;
        int bufferSize = this.contentLength > 0L ? (int)this.contentLength : this.bufferSize;
        this.ctx.channel().eventLoop().execute(() -> {
            this.ctx.write((Object)rsp, this.ctx.voidPromise());
            this.ctx.write((Object)new ChunkedNioStream(channel, bufferSize), this.ctx.voidPromise());
            this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)this);
        });
        return this;
    }

    @Nonnull
    public Context send(@Nonnull InputStream in) {
        if (in instanceof FileInputStream) {
            return this.send(((FileInputStream)in).getChannel());
        }
        try {
            this.prepareChunked();
            long len = this.responseLength();
            ByteRange range = ByteRange.parse((String)this.req.headers().get((CharSequence)HttpHeaderNames.RANGE), (long)len).apply((Context)this);
            ChunkedStream chunkedStream = new ChunkedStream(range.apply(in), this.bufferSize);
            DefaultHttpResponse rsp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.status, (HttpHeaders)this.setHeaders);
            this.responseStarted = true;
            this.ctx.channel().eventLoop().execute(() -> {
                this.ctx.write((Object)rsp, this.ctx.voidPromise());
                this.ctx.write((Object)chunkedStream, this.ctx.voidPromise());
                this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)this);
            });
            return this;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @Nonnull
    public Context send(@Nonnull FileChannel file) {
        try {
            long len = file.size();
            this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)Long.toString(len));
            ByteRange range = ByteRange.parse((String)this.req.headers().get((CharSequence)HttpHeaderNames.RANGE), (long)len).apply((Context)this);
            DefaultHttpResponse rsp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, this.status, (HttpHeaders)this.setHeaders);
            this.responseStarted = true;
            this.ctx.channel().eventLoop().execute(() -> {
                this.ctx.write((Object)rsp, this.ctx.voidPromise());
                this.ctx.write((Object)new DefaultFileRegion(file, range.getStart(), range.getEnd()), this.ctx.voidPromise());
                this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)this);
            });
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
        return this;
    }

    public boolean isResponseStarted() {
        return this.responseStarted;
    }

    public boolean getResetHeadersOnError() {
        return this.resetHeadersOnError == null ? this.getRouter().getRouterOptions().getResetHeadersOnError() : this.resetHeadersOnError.booleanValue();
    }

    public Context setResetHeadersOnError(boolean value) {
        this.resetHeadersOnError = value;
        return this;
    }

    @Nonnull
    public Context send(StatusCode statusCode) {
        this.responseStarted = true;
        if (!this.setHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            this.setHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)"0");
        }
        DefaultFullHttpResponse rsp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)statusCode.value()), Unpooled.EMPTY_BUFFER, (HttpHeaders)this.setHeaders, NO_TRAILING);
        this.ctx.writeAndFlush((Object)rsp).addListener((GenericFutureListener)this);
        return this;
    }

    public void operationComplete(ChannelFuture future) {
        try {
            this.ifSaveSession();
            this.destroy(future.cause());
        }
        finally {
            if (!HttpUtil.isKeepAlive((HttpMessage)this.req)) {
                future.channel().close();
            }
        }
    }

    private void ifSaveSession() {
        Session session = (Session)this.getAttributes().get("session");
        if (session != null && (session.isNew() || session.isModify())) {
            SessionStore store = this.router.getSessionStore();
            store.saveSession((Context)this, session);
        }
    }

    private NettyOutputStream newOutputStream() {
        this.prepareChunked();
        return new NettyOutputStream(this.ctx, this.bufferSize, (HttpResponse)new DefaultHttpResponse(this.req.protocolVersion(), this.status, (HttpHeaders)this.setHeaders), this);
    }

    void destroy(Throwable cause) {
        if (cause != null) {
            if (Server.connectionLost((Throwable)cause)) {
                this.router.getLog().debug("exception found while sending response {} {}", new Object[]{this.getMethod(), this.pathString(), cause});
            } else {
                this.router.getLog().error("exception found while sending response {} {}", new Object[]{this.getMethod(), this.pathString(), cause});
            }
        }
        if (this.files != null) {
            for (FileUpload file : this.files) {
                try {
                    file.destroy();
                }
                catch (Exception x) {
                    this.router.getLog().debug("file upload destroy resulted in exception", (Throwable)x);
                }
            }
            this.files = null;
        }
        if (this.decoder != null) {
            try {
                this.decoder.destroy();
            }
            catch (Exception x) {
                this.router.getLog().debug("body decoder destroy resulted in exception", (Throwable)x);
            }
            this.decoder = null;
        }
        NettyContext.release(this.req);
    }

    private FileUpload register(FileUpload upload) {
        if (this.files == null) {
            this.files = new ArrayList<FileUpload>();
        }
        this.files.add(upload);
        return upload;
    }

    private void decodeForm(HttpRequest req, Formdata form) {
        if (this.decoder == null) {
            return;
        }
        try {
            while (this.decoder.hasNext()) {
                HttpData next = (HttpData)this.decoder.next();
                if (next.getHttpDataType() == InterfaceHttpData.HttpDataType.FileUpload) {
                    ((Multipart)form).put(next.getName(), this.register(new NettyFileUpload(this.router.getTmpdir(), (io.netty.handler.codec.http.multipart.FileUpload)next)));
                    continue;
                }
                form.put(next.getName(), next.getString(StandardCharsets.UTF_8));
            }
        }
        catch (HttpPostRequestDecoder.EndOfDataDecoderException next) {
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
        finally {
            NettyContext.release(req);
        }
    }

    private static void release(HttpRequest req) {
        ReferenceCounted ref;
        if (req instanceof ReferenceCounted && (ref = (ReferenceCounted)req).refCnt() > 0) {
            ref.release();
        }
    }

    private long responseLength() {
        String len = this.setHeaders.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
        return len == null ? -1L : Long.parseLong(len);
    }

    private void prepareChunked() {
        ChannelPipeline pipeline = this.ctx.pipeline();
        if (pipeline.get("chunker") == null) {
            pipeline.addAfter("encoder", "chunker", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (!this.setHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
            this.setHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        }
    }

    public String toString() {
        return this.getMethod() + " " + this.pathString();
    }
}

