/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.netty;

import io.jooby.Jooby;
import io.jooby.Router;
import io.jooby.Server;
import io.jooby.ServerOptions;
import io.jooby.SneakyThrows;
import io.jooby.internal.netty.NettyPipeline;
import io.jooby.internal.netty.NettyTransport;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.BindException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;

public class Netty
extends Server.Base {
    private static final int _50 = 50;
    private static final int _100 = 100;
    private List<Jooby> applications = new ArrayList<Jooby>();
    private EventLoopGroup acceptorloop;
    private EventLoopGroup eventloop;
    private ExecutorService worker;
    private ServerOptions options = new ServerOptions().setServer("netty");

    public Netty setOptions(@Nonnull ServerOptions options) {
        this.options = options;
        return this;
    }

    @Nonnull
    public ServerOptions getOptions() {
        return this.options;
    }

    @Nonnull
    public Server start(@Nonnull Jooby application) {
        try {
            String tmpdir;
            this.applications.add(application);
            this.addShutdownHook();
            this.worker = Executors.newFixedThreadPool(this.options.getWorkerThreads(), (ThreadFactory)new DefaultThreadFactory("worker"));
            this.fireStart(this.applications, this.worker);
            DiskFileUpload.baseDirectory = tmpdir = this.applications.get(0).getTmpdir().toString();
            DiskAttribute.baseDirectory = tmpdir;
            NettyTransport transport = NettyTransport.transport(application.getClassLoader());
            this.acceptorloop = transport.createEventLoop(1, "acceptor", 50);
            this.eventloop = transport.createEventLoop(this.options.getIoThreads(), "eventloop", 100);
            DefaultHttpDataFactory factory = new DefaultHttpDataFactory((long)this.options.getBufferSize());
            ServerBootstrap bootstrap = transport.configure(this.acceptorloop, this.eventloop).childHandler((ChannelHandler)new NettyPipeline((ScheduledExecutorService)this.acceptorloop.next(), (Router)this.applications.get(0), (HttpDataFactory)factory, this.options.getDefaultHeaders(), this.options.getGzip(), this.options.getBufferSize(), this.options.getMaxRequestSize())).childOption(ChannelOption.SO_REUSEADDR, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap.bind("0.0.0.0", this.options.getPort()).get();
            this.fireReady(this.applications);
        }
        catch (InterruptedException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
        catch (ExecutionException x) {
            Throwable cause = x.getCause();
            if (cause instanceof BindException) {
                cause = new BindException("Address already in use: " + this.options.getPort());
            }
            throw SneakyThrows.propagate((Throwable)cause);
        }
        return this;
    }

    @Nonnull
    public synchronized Server stop() {
        this.fireStop(this.applications);
        if (this.acceptorloop != null) {
            this.acceptorloop.shutdownGracefully();
            this.acceptorloop = null;
        }
        if (this.eventloop != null) {
            this.eventloop.shutdownGracefully();
            this.eventloop = null;
        }
        if (this.worker != null) {
            this.worker.shutdown();
            this.worker = null;
        }
        return this;
    }

    static {
        System.setProperty("io.netty.leakDetection.level", System.getProperty("io.netty.leakDetection.level", "disabled"));
    }
}

