/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.servlet;

import io.jenkins.servlet.FilterChainWrapper;
import io.jenkins.servlet.FilterConfigWrapper;
import io.jenkins.servlet.ServletExceptionWrapper;
import io.jenkins.servlet.ServletRequestWrapper;
import io.jenkins.servlet.ServletResponseWrapper;
import io.jenkins.servlet.http.HttpServletRequestWrapper;
import io.jenkins.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class FilterWrapper {
    public static Filter toJakartaFilter(final javax.servlet.Filter from) {
        Objects.requireNonNull(from);
        return new Filter(){

            public void init(jakarta.servlet.FilterConfig filterConfig) throws jakarta.servlet.ServletException {
                try {
                    from.init(FilterConfigWrapper.fromJakartaFilterConfig(filterConfig));
                }
                catch (ServletException e) {
                    throw ServletExceptionWrapper.toJakartaServletException(e);
                }
            }

            public void doFilter(jakarta.servlet.ServletRequest request, jakarta.servlet.ServletResponse response, FilterChain chain) throws IOException, jakarta.servlet.ServletException {
                try {
                    if (request instanceof HttpServletRequest && response instanceof jakarta.servlet.http.HttpServletResponse) {
                        HttpServletRequest httpRequest = (HttpServletRequest)request;
                        jakarta.servlet.http.HttpServletResponse httpResponse = (jakarta.servlet.http.HttpServletResponse)response;
                        from.doFilter(HttpServletRequestWrapper.fromJakartaHttpServletRequest(httpRequest), HttpServletResponseWrapper.fromJakartaHttpServletResponse(httpResponse), FilterChainWrapper.fromJakartaFilterChain(chain));
                    } else {
                        from.doFilter(ServletRequestWrapper.fromJakartaServletRequest(request), ServletResponseWrapper.fromJakartaServletResponse(response), FilterChainWrapper.fromJakartaFilterChain(chain));
                    }
                }
                catch (ServletException e) {
                    throw ServletExceptionWrapper.toJakartaServletException(e);
                }
            }

            public void destroy() {
                from.destroy();
            }
        };
    }

    public static javax.servlet.Filter fromJakartaFilter(final Filter from) {
        Objects.requireNonNull(from);
        return new javax.servlet.Filter(){

            @Override
            public void init(FilterConfig filterConfig) throws ServletException {
                try {
                    from.init(FilterConfigWrapper.toJakartaFilterConfig(filterConfig));
                }
                catch (jakarta.servlet.ServletException e) {
                    throw ServletExceptionWrapper.fromJakartaServletException(e);
                }
            }

            @Override
            public void doFilter(ServletRequest request, ServletResponse response, javax.servlet.FilterChain chain) throws IOException, ServletException {
                try {
                    if (request instanceof javax.servlet.http.HttpServletRequest && response instanceof HttpServletResponse) {
                        javax.servlet.http.HttpServletRequest httpRequest = (javax.servlet.http.HttpServletRequest)request;
                        HttpServletResponse httpResponse = (HttpServletResponse)response;
                        from.doFilter((jakarta.servlet.ServletRequest)HttpServletRequestWrapper.toJakartaHttpServletRequest(httpRequest), (jakarta.servlet.ServletResponse)HttpServletResponseWrapper.toJakartaHttpServletResponse(httpResponse), FilterChainWrapper.toJakartaFilterChain(chain));
                    } else {
                        from.doFilter(ServletRequestWrapper.toJakartaServletRequest(request), ServletResponseWrapper.toJakartaServletResponse(response), FilterChainWrapper.toJakartaFilterChain(chain));
                    }
                }
                catch (jakarta.servlet.ServletException e) {
                    throw ServletExceptionWrapper.fromJakartaServletException(e);
                }
            }

            @Override
            public void destroy() {
                from.destroy();
            }
        };
    }
}

