/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.VisualExpert;

import com.google.common.base.Strings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.StreamBuildListener;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.VisualExpert.Messages;
import io.jenkins.plugins.VisualExpert.VisualExpertHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Scanner;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class VisualExpertBuilder
extends Builder
implements SimpleBuildStep {
    private String _projectName;
    private String _installPath;
    private boolean _doAnalysis = true;
    private boolean _createReferenceDocument;
    private boolean _createCodeReviewDocument;
    private ArrayList<String> projectList;
    private static final String DEFAULT_INSTALLATION_PATH = "C:\\Program Files (x86)\\Novalys\\Visual Expert 2021\\Novalys.VisualExpert.Console.exe";
    private static final String GENERATE_DOCUMENTATION_SUCCESS_STRING = "Documentation generated for the project";
    private static final String ANALYZE_PROJECT_SUCCESS_STRING = "Analysis completed successfully for the project";

    @DataBoundConstructor
    public VisualExpertBuilder(String installPath, String projectName, Boolean doAnalysis, Boolean createReferenceDocument, Boolean createCodeReviewDocument) {
        this._installPath = installPath;
        this._projectName = projectName;
        this._doAnalysis = doAnalysis;
        this._createReferenceDocument = createReferenceDocument;
        this._createCodeReviewDocument = createCodeReviewDocument;
    }

    public VisualExpertBuilder(String installPath) {
        this._installPath = installPath;
    }

    public String getInstallPath() {
        if (StringUtils.isEmpty((String)this._installPath)) {
            this._installPath = DEFAULT_INSTALLATION_PATH;
        }
        return this._installPath;
    }

    public String getProjectName() {
        return this._projectName;
    }

    public boolean isDoAnalysis() {
        return this._doAnalysis;
    }

    public boolean isCreateReferenceDocument() {
        return this._createReferenceDocument;
    }

    public boolean isCreateCodeReviewDocument() {
        return this._createCodeReviewDocument;
    }

    public ArrayList<String> getProjectList() {
        if (null == this.projectList || this.projectList.isEmpty()) {
            this.projectList = VisualExpertHelper.ReadProjectsFile(this._installPath);
        }
        return this.projectList;
    }

    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        TaskListener taskListener;
        listener.getLogger().println("Installation Path: " + this._installPath);
        listener.getLogger().println("Visual Expert Project Name: " + this._projectName);
        listener.getLogger().println("Analyze Project: " + this._doAnalysis);
        listener.getLogger().println("Generate Reference Documentation: " + this._createReferenceDocument);
        listener.getLogger().println("Generate Code Review Documentation: " + this._createCodeReviewDocument);
        String visualExpertCommandOutputFileName = null;
        boolean isAnalysisSucceeded = true;
        boolean isReferenceDocumentGenerated = true;
        boolean isCodeReviewDocumentGenerated = true;
        if (this._doAnalysis) {
            visualExpertCommandOutputFileName = VisualExpertHelper.GetVisualExpertCommandOutputFile();
            taskListener = VisualExpertHelper.GetVisualExpertCommandOutputListener(visualExpertCommandOutputFileName);
            launcher.launch().cmds(VisualExpertHelper.GetCommandLine(this._installPath + " " + " -a -p '" + this._projectName + "'")).stdout(taskListener).join();
            isAnalysisSucceeded = VisualExpertHelper.VerifyOutput(visualExpertCommandOutputFileName, ANALYZE_PROJECT_SUCCESS_STRING, true, listener);
        }
        if (this._createReferenceDocument) {
            if (null == visualExpertCommandOutputFileName) {
                visualExpertCommandOutputFileName = VisualExpertHelper.GetVisualExpertCommandOutputFile();
            }
            taskListener = VisualExpertHelper.GetVisualExpertCommandOutputListener(visualExpertCommandOutputFileName);
            launcher.launch().cmds(VisualExpertHelper.GetCommandLine(this._installPath + " " + " -d -p '" + this._projectName + "'" + " -t reference")).stdout(taskListener).join();
            isReferenceDocumentGenerated = VisualExpertHelper.VerifyOutput(visualExpertCommandOutputFileName, GENERATE_DOCUMENTATION_SUCCESS_STRING, true, listener);
        }
        if (this._createCodeReviewDocument) {
            if (null == visualExpertCommandOutputFileName) {
                visualExpertCommandOutputFileName = VisualExpertHelper.GetVisualExpertCommandOutputFile();
            }
            taskListener = VisualExpertHelper.GetVisualExpertCommandOutputListener(visualExpertCommandOutputFileName);
            launcher.launch().cmds(VisualExpertHelper.GetCommandLine(this._installPath + " " + " -d -p '" + this._projectName + "'" + " -t codereview")).stdout(taskListener).join();
            isCodeReviewDocumentGenerated = VisualExpertHelper.VerifyOutput(visualExpertCommandOutputFileName, GENERATE_DOCUMENTATION_SUCCESS_STRING, true, listener);
        }
        if (!(isAnalysisSucceeded && isReferenceDocumentGenerated && isCodeReviewDocumentGenerated)) {
            run.setResult(Result.FAILURE);
        }
    }

    public static class VEProjectsLister {
        public static volatile VEProjectsLister instance;
        public static volatile String lastappPath;
        private static final Object mutex;
        private ArrayList<String> commonProjectList;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static VEProjectsLister getInstance(String installationPath, String defaultProjectsFilePath) {
            VEProjectsLister result = instance;
            if (result == null) {
                Object object = mutex;
                synchronized (object) {
                    result = instance;
                    if (result == null) {
                        lastappPath = installationPath;
                        instance = result = new VEProjectsLister(installationPath, defaultProjectsFilePath);
                    } else if (lastappPath == null || !lastappPath.equals(installationPath)) {
                        lastappPath = installationPath;
                        instance = result = new VEProjectsLister(installationPath, defaultProjectsFilePath);
                    }
                }
            } else if (lastappPath == null || !lastappPath.equals(installationPath)) {
                lastappPath = installationPath;
                instance = result = new VEProjectsLister(installationPath, defaultProjectsFilePath);
            }
            return result;
        }

        public ArrayList<String> getProjects() {
            return this.commonProjectList;
        }

        private VEProjectsLister(String installationPath, String defaultProjectsFilePath) {
            this.readProjectsFile(installationPath, defaultProjectsFilePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public ArrayList<String> readProjectsFile(String installationPath, String defaultProjectsFilePath) {
            if (this.commonProjectList != null && !this.commonProjectList.isEmpty()) {
                return this.commonProjectList;
            }
            ArgumentListBuilder commandArgument = new ArgumentListBuilder();
            commandArgument.addTokenized(installationPath + " " + " -L ");
            this.commonProjectList = new ArrayList();
            String projectsFileName = null;
            try {
                StreamBuildListener listener = new StreamBuildListener((OutputStream)new ByteArrayOutputStream());
                new Launcher.LocalLauncher((TaskListener)listener).launch().cmds(commandArgument).stdout((TaskListener)listener).start().joinWithTimeout(300L, TimeUnit.SECONDS, (TaskListener)listener);
                Scanner projectScanner = null;
                try {
                    String programDataFolder = System.getenv("PROGRAMDATA");
                    projectsFileName = programDataFolder + defaultProjectsFilePath;
                    File projectFile = new File(projectsFileName);
                    if (!projectFile.exists()) {
                        ArrayList<String> arrayList = this.commonProjectList;
                        return arrayList;
                    }
                    projectScanner = new Scanner(projectFile, "UTF-8");
                    boolean isFirstLine = true;
                    while (projectScanner.hasNextLine()) {
                        String line = projectScanner.nextLine();
                        if (isFirstLine && line.length() > 1) {
                            if (line.charAt(0) == '\ufeff') {
                                line = line.substring(1, line.length());
                            }
                            isFirstLine = false;
                        }
                        this.commonProjectList.add(line);
                    }
                    projectScanner.close();
                }
                catch (Exception e) {
                    System.out.println("ReadProjectsFile -> Exception occurred  in file: " + projectsFileName);
                }
                finally {
                    try {
                        if (projectScanner != null) {
                            projectScanner.close();
                        }
                    }
                    catch (Exception eex) {}
                }
            }
            catch (FileNotFoundException ex) {
                System.out.println("ReadProjectsFile -> FileNotFoundException occurred  in file: " + projectsFileName);
            }
            catch (IOException x) {
                System.out.println("ReadProjectsFile -> IOException occurred in file: " + projectsFileName);
            }
            catch (Exception e) {
                System.out.println("ReadProjectsFile -> Exception occurred");
            }
            System.out.println("Total Projects -> " + this.commonProjectList.size());
            return this.commonProjectList;
        }

        static {
            mutex = new Object();
        }
    }

    @Symbol(value={"visualexpert"})
    @Extension
    public static final class Descriptor
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Visual Expert";
        }

        @POST
        public FormValidation doCheckProjectName(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (Util.fixEmptyAndTrim((String)value) == null || value.equals("null")) {
                return FormValidation.error((String)Messages.VisualExpertBuilder_DescriptorImpl_errors_missingName());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCreateCodeReviewDocument(@AncestorInPath Item item, @QueryParameter boolean doAnalysis, @QueryParameter boolean createReferenceDocument, @QueryParameter String value) throws IOException, ServletException {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (Util.fixEmptyAndTrim((String)value) == null || !Boolean.parseBoolean(value) && !doAnalysis && !createReferenceDocument) {
                return FormValidation.error((String)Messages.VisualExpertBuilder_DescriptorImpl_errors_atLeastOneCheck());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckInstallPath(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (Util.fixEmptyAndTrim((String)value) == null) {
                return FormValidation.error((String)Messages.VisualExpertBuilder_DescriptorImpl_errors_missingInstallPath());
            }
            File f = new File(value);
            if (!f.exists()) {
                return FormValidation.error((String)Messages.VisualExpertBuilder_DescriptorImpl_errors_installPathNotExist());
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillProjectNameItems(@AncestorInPath Item item, @QueryParameter String projectName, @QueryParameter String installPath) {
            ListBoxModel model = new ListBoxModel();
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return model;
            }
            model.add((Object)new ListBoxModel.Option("--- Select Project ---", null, Strings.isNullOrEmpty((String)projectName)));
            if (installPath.isEmpty()) {
                return model;
            }
            ArrayList<String> projectList = VisualExpertHelper.ReadProjectsFile(installPath);
            if (null == projectList) {
                return model;
            }
            for (String project : projectList) {
                model.add((Object)new ListBoxModel.Option(project, project, project.equals(projectName)));
            }
            return model;
        }
    }
}

