/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.exception;

import java.util.Objects;

public class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int errorCode;
    private String errorDescription;

    public ValidationException(Throwable cause) {
        super(cause);
    }

    public ValidationException(String message) {
        super(message);
    }

    public ValidationException(int code, String message) {
        super(ValidationException.buildMessage(code, null, message));
        this.errorCode = code;
    }

    public ValidationException(int code, String message, Throwable cause) {
        super(ValidationException.buildMessage(code, null, message), cause);
        this.errorCode = code;
    }

    public ValidationException(int code, String errorDescription, String message) {
        super(ValidationException.buildMessage(code, errorDescription, message));
        this.errorCode = code;
        this.errorDescription = errorDescription;
    }

    public ValidationException(int code, String errorDescription, String message, Throwable cause) {
        super(ValidationException.buildMessage(code, errorDescription, message), cause);
        this.errorCode = code;
        this.errorDescription = errorDescription;
    }

    private static String buildMessage(int code, String errorDescription, String message) {
        return message + " (errorCode: " + code + (Objects.nonNull(errorDescription) ? "-" + errorDescription : "") + ")";
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }
}

