/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_oauth;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import hudson.Extension;
import hudson.model.UnprotectedRootAction;
import hudson.security.SecurityRealm;
import io.jenkins.plugins.tuleap_oauth.TuleapSecurityRealm;
import io.jenkins.plugins.tuleap_oauth.guice.TuleapOAuth2GuiceModule;
import io.jenkins.plugins.tuleap_oauth.helper.PluginHelper;
import javax.annotation.CheckForNull;

@Extension
public class TuleapLogoutAction
implements UnprotectedRootAction {
    static final String REDIRECT_ON_LOGOUT = "tuleapLogout";
    private PluginHelper pluginHelper;

    public TuleapLogoutAction() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TuleapOAuth2GuiceModule()});
        this.pluginHelper = (PluginHelper)injector.getInstance(PluginHelper.class);
    }

    public TuleapLogoutAction(PluginHelper pluginHelper) {
        this.pluginHelper = pluginHelper;
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return "Tuleap logout";
    }

    @CheckForNull
    public String getUrlName() {
        return REDIRECT_ON_LOGOUT;
    }

    public String getTuleapUrl() {
        SecurityRealm realm = this.pluginHelper.getJenkinsInstance().getSecurityRealm();
        if (realm instanceof TuleapSecurityRealm) {
            return ((TuleapSecurityRealm)realm).getTuleapUri();
        }
        return "";
    }
}

