/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_oauth.helper;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.jenkins.plugins.tuleap_api.client.UserApi;
import io.jenkins.plugins.tuleap_api.client.UserGroup;
import io.jenkins.plugins.tuleap_api.client.authentication.AccessToken;
import io.jenkins.plugins.tuleap_oauth.helper.TuleapGroupHelper;
import java.util.List;
import java.util.stream.Collectors;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;

public class UserAuthoritiesRetriever {
    private final UserApi userApi;
    private final TuleapGroupHelper tuleapGroupHelper;

    @Inject
    public UserAuthoritiesRetriever(UserApi userApi, TuleapGroupHelper tuleapGroupHelper) {
        this.userApi = userApi;
        this.tuleapGroupHelper = tuleapGroupHelper;
    }

    public List<GrantedAuthority> getAuthoritiesForUser(AccessToken accessToken) {
        ImmutableList userGroups = this.userApi.getUserMembership(accessToken);
        return userGroups.stream().map(userGroup -> new GrantedAuthorityImpl(this.tuleapGroupHelper.buildJenkinsName((UserGroup)userGroup))).collect(Collectors.toList());
    }
}

