/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tics;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tics.MeasureApiCall;
import hudson.plugins.tics.TicsPublisherBuildAction;
import hudson.plugins.tics.TicsQualityGate;
import hudson.plugins.tics.TqiPublisherResultBuilder;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class TicsPublisher
extends Recorder
implements SimpleBuildStep {
    static final String LOGGING_PREFIX = "[TICS Publisher] ";
    private final String ticsPath;
    private final String viewerUrl;
    private final String credentialsId;
    private final boolean checkQualityGate;
    private final boolean failIfQualityGateFails;

    @DataBoundConstructor
    public TicsPublisher(String viewerUrl, String ticsPath, String credentialsId, boolean checkQualityGate, boolean failIfQualityGateFails) {
        this.viewerUrl = viewerUrl;
        this.ticsPath = ticsPath;
        this.credentialsId = credentialsId;
        this.checkQualityGate = checkQualityGate;
        this.failIfQualityGateFails = failIfQualityGateFails;
    }

    public String getTicsPath() {
        return this.ticsPath;
    }

    public String getViewerUrl() {
        return this.viewerUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public boolean hasGlobalViewerUrl() {
        return !Strings.isNullOrEmpty((String)this.getDescriptor().getViewerUrl());
    }

    public String getGlobalViewerUrl() {
        return this.getDescriptor().getViewerUrl();
    }

    public boolean getCheckQualityGate() {
        return this.checkQualityGate;
    }

    public boolean getFailIfQualityGateFails() {
        return this.failIfQualityGateFails;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, RuntimeException, InterruptedException {
        TqiPublisherResultBuilder.TqiPublisherResult tqiLabelResult;
        String tiobeWebBaseUrl;
        String qualityGateUrl;
        String measureApiUrl;
        Optional<StandardUsernamePasswordCredentials> credentials = TicsPublisher.getStandardUsernameCredentials(run.getParent(), this.credentialsId);
        String ticsPath1 = Util.replaceMacro((String)((String)Preconditions.checkNotNull((Object)Strings.emptyToNull((String)this.ticsPath), (Object)"Path not specified")), (Map)run.getEnvironment(listener));
        try {
            measureApiUrl = this.getResolvedTiobewebBaseUrl() + "/api/public/v1/Measure";
            qualityGateUrl = this.getResolvedTiobewebBaseUrl() + "/api/public/v1/QualityGateStatus";
            tiobeWebBaseUrl = this.getResolvedTiobewebBaseUrl();
        }
        catch (InvalidTicsViewerUrl ex) {
            ex.printStackTrace(listener.getLogger());
            throw new IllegalArgumentException("[TICS Publisher] Invalid TICS Viewer URL", ex);
        }
        TqiPublisherResultBuilder builder = new TqiPublisherResultBuilder(listener.getLogger(), credentials, measureApiUrl, ticsPath1);
        TicsQualityGate.QualityGateResult qualityGateResult = null;
        try {
            tqiLabelResult = builder.run();
        }
        catch (Exception e) {
            listener.getLogger().println(LOGGING_PREFIX + e.getMessage());
            listener.getLogger().println(Throwables.getStackTraceAsString((Throwable)e));
            tqiLabelResult = null;
        }
        if (this.checkQualityGate) {
            TicsQualityGate qualityGate = new TicsQualityGate(qualityGateUrl, tiobeWebBaseUrl, this.failIfQualityGateFails, ticsPath1, credentials, run, listener);
            try {
                qualityGateResult = qualityGate.createQualityGateResult();
            }
            catch (Exception e) {
                qualityGateResult = null;
                if (this.failIfQualityGateFails) {
                    run.setResult(Result.FAILURE);
                }
                listener.getLogger().println(Throwables.getStackTraceAsString((Throwable)e));
            }
        }
        run.addAction((Action)new TicsPublisherBuildAction(run, tqiLabelResult, qualityGateResult, tiobeWebBaseUrl));
        run.setResult(Result.SUCCESS);
    }

    static Optional<StandardUsernamePasswordCredentials> getStandardUsernameCredentials(Job<?, ?> job, String credentialsId) {
        if (Strings.isNullOrEmpty((String)credentialsId)) {
            return Optional.empty();
        }
        List domainRequirements = Collections.emptyList();
        List list = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, job, (Authentication)ACL.SYSTEM, domainRequirements);
        for (StandardUsernamePasswordCredentials c : list) {
            if (!credentialsId.equals(c.getId())) continue;
            return Optional.of(c);
        }
        return Optional.empty();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public static String getMeasureApiUrl(String tiobewebBaseUrl) {
        return tiobewebBaseUrl + "/api/public/v1/Measure";
    }

    public String getResolvedTiobewebBaseUrl() throws InvalidTicsViewerUrl {
        Optional<String> optUrl = Optional.ofNullable(Strings.emptyToNull((String)this.getViewerUrl()));
        if (!optUrl.isPresent()) {
            optUrl = Optional.ofNullable(Strings.emptyToNull((String)this.getDescriptor().getViewerUrl()));
        }
        if (!optUrl.isPresent()) {
            throw new InvalidTicsViewerUrl("TICS Viewer URL was not configured at project level or globally.");
        }
        return TicsPublisher.getTiobewebBaseUrlFromGivenUrl(optUrl.get());
    }

    public static String getTiobewebBaseUrlFromGivenUrl(String arg0) throws InvalidTicsViewerUrl {
        String url = StringUtils.stripEnd((String)arg0, (String)"/");
        ArrayList parts = Lists.newArrayList((Iterable)Splitter.on((String)"/").split((CharSequence)url));
        if (parts.size() < 3) {
            throw new InvalidTicsViewerUrl("Missing host name in TICS Viewer URL");
        }
        if (parts.size() < 5) {
            throw new InvalidTicsViewerUrl("Missing section name in TICS Viewer URL");
        }
        parts.set(3, "tiobeweb");
        return Joiner.on((String)"/").join(parts.subList(0, 5));
    }

    static class InvalidTicsViewerUrl
    extends Exception {
        public InvalidTicsViewerUrl(String msg) {
            super(msg);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String globalViewerUrl;

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Publish TICS results";
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject json) throws Descriptor.FormException {
            this.globalViewerUrl = json.getString("globalViewerUrl");
            this.save();
            return true;
        }

        private static Optional<FormValidation> checkViewerUrlForErrorsCommon(String url) {
            if (Strings.isNullOrEmpty((String)url)) {
                return Optional.of(FormValidation.error((String)"Field is required"));
            }
            if (!url.matches("[^:/]+://[^/]+/[^/]+/[^/]+/?")) {
                return Optional.of(FormValidation.errorWithMarkup((String)"URL should be of the form <code>http(s)://hostname/tiobeweb/section</code>"));
            }
            try {
                String measureApiUrl = TicsPublisher.getMeasureApiUrl(TicsPublisher.getTiobewebBaseUrlFromGivenUrl(url));
                PrintStream dummyLogger = new PrintStream(new ByteArrayOutputStream());
                MeasureApiCall apiCall = new MeasureApiCall(dummyLogger, measureApiUrl, Optional.empty());
                apiCall.execute(MeasureApiCall.RESPONSE_DOUBLE_TYPETOKEN, "HIE://", "none");
                return Optional.empty();
            }
            catch (MeasureApiCall.MeasureApiCallException e) {
                return Optional.of(FormValidation.errorWithMarkup((String)e.getMessage()));
            }
            catch (InvalidTicsViewerUrl e) {
                return Optional.of(FormValidation.errorWithMarkup((String)e.getMessage()));
            }
        }

        private static Optional<FormValidation> checkViewerUrlForWarningsCommon(String value) {
            String host;
            try {
                host = new URIBuilder(value).getHost();
            }
            catch (URISyntaxException e) {
                return Optional.empty();
            }
            if (host.equals("localhost") || host.equals("127.0.0.1")) {
                return Optional.of(FormValidation.warning((String)("Please provide a publicly accessible host, instead of " + host)));
            }
            return Optional.empty();
        }

        private FormValidation checkViewerUrlForErrorsOrWarnings(String value) {
            if (Strings.isNullOrEmpty((String)value)) {
                return FormValidation.ok();
            }
            Optional<FormValidation> validation = DescriptorImpl.checkViewerUrlForErrorsCommon(value);
            if (validation.isPresent()) {
                return validation.get();
            }
            validation = DescriptorImpl.checkViewerUrlForWarningsCommon(value);
            if (validation.isPresent()) {
                return validation.get();
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckViewerUrl(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value) throws IOException, InterruptedException {
            if (project == null) {
                return FormValidation.ok();
            }
            project.checkPermission(Item.CONFIGURE);
            EnvVars envvars = project.getEnvironment(null, null);
            if (Strings.isNullOrEmpty((String)value)) {
                String globalViewerUrl2 = Util.replaceMacro((String)Strings.nullToEmpty((String)this.globalViewerUrl), (Map)envvars);
                if (Strings.isNullOrEmpty((String)globalViewerUrl2)) {
                    return FormValidation.error((String)"Field is required");
                }
                Optional<FormValidation> error = DescriptorImpl.checkViewerUrlForErrorsCommon(globalViewerUrl2);
                if (error.isPresent()) {
                    return FormValidation.errorWithMarkup((String)("Global setting (" + globalViewerUrl2 + ") is invalid: " + error.get().getMessage()));
                }
                return FormValidation.okWithMarkup((String)("Using global setting: " + globalViewerUrl2));
            }
            return this.checkViewerUrlForErrorsOrWarnings(Util.replaceMacro((String)value, (Map)envvars));
        }

        @POST
        public FormValidation doCheckGlobalViewerUrl(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null) {
                return FormValidation.ok();
            }
            item.checkPermission(Item.CONFIGURE);
            return this.checkViewerUrlForErrorsOrWarnings(value);
        }

        @POST
        public FormValidation doCheckTicsPath(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String value, @QueryParameter String viewerUrl, @QueryParameter String credentialsId) throws IOException, InterruptedException {
            if (project == null) {
                return FormValidation.ok();
            }
            project.checkPermission(Item.CONFIGURE);
            if (Strings.isNullOrEmpty((String)value)) {
                return FormValidation.error((String)"Field is required");
            }
            if (!value.matches("^[^:/]+://[^/]+/.+$")) {
                return FormValidation.errorWithMarkup((String)"Path should start with <code>hierarchy://project/branch</code>, where <code>hierarchy</code> is either <code>HIE</code> or <code>ORG</code>.");
            }
            String resolvedViewerUrl = Optional.ofNullable(Strings.emptyToNull((String)viewerUrl)).orElse(Strings.nullToEmpty((String)this.globalViewerUrl));
            if (DescriptorImpl.checkViewerUrlForErrorsCommon(resolvedViewerUrl).isPresent()) {
                return FormValidation.ok();
            }
            try {
                EnvVars envvars = project.getEnvironment(null, null);
                String measureApiUrl = TicsPublisher.getMeasureApiUrl(TicsPublisher.getTiobewebBaseUrlFromGivenUrl(Util.replaceMacro((String)resolvedViewerUrl, (Map)envvars)));
                Optional<StandardUsernamePasswordCredentials> creds = TicsPublisher.getStandardUsernameCredentials(project, credentialsId);
                PrintStream dummyLogger = new PrintStream(new ByteArrayOutputStream());
                MeasureApiCall apiCall = new MeasureApiCall(dummyLogger, measureApiUrl, creds);
                apiCall.execute(MeasureApiCall.RESPONSE_DOUBLE_TYPETOKEN, Util.replaceMacro((String)value, (Map)envvars), "none");
                return FormValidation.ok();
            }
            catch (MeasureApiCall.MeasureApiCallException e) {
                return FormValidation.errorWithMarkup((String)e.getMessage());
            }
            catch (InvalidTicsViewerUrl e) {
                return FormValidation.errorWithMarkup((String)e.getMessage());
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getViewerUrl() {
            return this.globalViewerUrl;
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            CredentialsMatcher credentialsMatcher = CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)});
            StandardListBoxModel result = new StandardListBoxModel();
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !context.hasPermission(Item.CONFIGURE)) {
                return result.includeCurrentValue(credentialsId);
            }
            List domainRequirements = credentialsId == null ? Collections.emptyList() : URIRequirementBuilder.fromUri((String)credentialsId.trim()).build();
            return result.includeEmptyValue().includeMatchingAs(ACL.SYSTEM, context, StandardCredentials.class, domainRequirements, credentialsMatcher);
        }
    }
}

