/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tics;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernameCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.google.common.base.Strings;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.ItemGroup;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tics.TicsPublisher;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TicsPipelinePublish
extends Recorder
implements SimpleBuildStep {
    private static final String PUBLISH_TICS_RESULTS = "publishTicsResults";
    public final String viewerUrl;
    public String projectName;
    public String branchName;
    public String ticsProjectPath;
    public String userName;
    public String userId;
    public boolean checkQualityGate;
    public boolean failIfQualityGateFails;

    @DataBoundConstructor
    public TicsPipelinePublish(String viewerUrl) {
        this.viewerUrl = viewerUrl;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        if (Strings.isNullOrEmpty((String)this.viewerUrl)) {
            throw new IllegalArgumentException("The pipeline method 'publishTicsResults' was used without specifying the 'viewerUrl'. For instance a 'viewerUrl' looks like: 'http://www.company.com:42506/tiobeweb/TICS'.\n");
        }
        if ((Strings.isNullOrEmpty((String)this.projectName) || Strings.isNullOrEmpty((String)this.branchName)) && Strings.isNullOrEmpty((String)this.ticsProjectPath)) {
            throw new IllegalArgumentException("The pipeline method 'publishTicsResults' was used without specifying the 'projectName' or the 'branchName'.");
        }
        String credentialsId = this.getCredentials();
        TicsPublisher tp = new TicsPublisher(this.viewerUrl, this.getTicsProjectPath(), credentialsId, this.checkQualityGate, this.failIfQualityGateFails);
        tp.perform(run, workspace, launcher, listener);
    }

    private String getTicsProjectPath() {
        if (Strings.isNullOrEmpty((String)this.ticsProjectPath)) {
            return String.join((CharSequence)"/", "HIE:/", this.projectName, this.branchName);
        }
        return this.ticsProjectPath;
    }

    private String getCredentials() {
        if (Strings.isNullOrEmpty((String)this.userName) && Strings.isNullOrEmpty((String)this.userId)) {
            return "";
        }
        if (!Strings.isNullOrEmpty((String)this.userName) && !Strings.isNullOrEmpty((String)this.userId)) {
            throw new IllegalArgumentException("Please specify either one of the the 'userName' or 'userId' and not both.");
        }
        if (!Strings.isNullOrEmpty((String)this.userId)) {
            return this.findUserCredentials("userId", this.userId, IdCredentials::getId);
        }
        return this.findUserCredentials("userName", this.userName, UsernameCredentials::getUsername);
    }

    private String findUserCredentials(String targetName, String targetValue, Function<StandardUsernamePasswordCredentials, String> func) {
        List credentialsList = CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstanceOrNull(), null, (DomainRequirement[])new DomainRequirement[]{null});
        String exceptionMessage = "No credentials found for " + targetName + ":'" + targetValue + "' in Jenkins credentials store.";
        StandardUsernamePasswordCredentials findUserInCredentialsList = credentialsList.stream().filter(c -> ((String)func.apply((StandardUsernamePasswordCredentials)c)).equals(targetValue)).findFirst().orElseThrow(() -> new RuntimeException(exceptionMessage));
        return findUserInCredentialsList.getId();
    }

    @DataBoundSetter
    public void setProjectName(String value) {
        this.projectName = value;
    }

    @DataBoundSetter
    public void setBranchName(String value) {
        this.branchName = value;
    }

    @DataBoundSetter
    public void setTicsProjectPath(String value) {
        this.ticsProjectPath = value;
    }

    @DataBoundSetter
    public void setUserName(String value) {
        this.userName = value;
    }

    @DataBoundSetter
    public void setUserId(String value) {
        this.userId = value;
    }

    @DataBoundSetter
    public void setCheckQualityGate(boolean value) {
        this.checkQualityGate = value;
    }

    @DataBoundSetter
    public void setFailIfQualityGateFails(boolean value) {
        this.failIfQualityGateFails = value;
    }

    @Symbol(value={"publishTicsResults"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @Nonnull
        public String getDisplayName() {
            return "";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

