/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tics;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.tics.Metrics;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.ArgumentListBuilder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class TicsAnalyzer
extends Builder
implements SimpleBuildStep {
    static final String LOGGING_PREFIX = "[TICS Analyzer] ";
    public final String ticsPath;
    public final String ticsConfiguration;
    public final String projectName;
    public final String branchName;
    public final String branchDirectory;
    public final String environmentVariables;
    public final boolean createTmpdir;
    public final String tmpdir;
    public final String extraArguments;
    public final Metrics calc;
    public final Metrics recalc;

    @DataBoundConstructor
    public TicsAnalyzer(String ticsPath, String ticsConfiguration, String projectName, String branchName, String branchDirectory, String environmentVariables, boolean createTmpdir, String tmpdir, String extraArguments, Metrics calc, Metrics recalc) {
        this.ticsPath = ticsPath;
        this.ticsConfiguration = ticsConfiguration;
        this.projectName = projectName;
        this.branchName = branchName;
        this.branchDirectory = branchDirectory;
        this.environmentVariables = environmentVariables;
        this.createTmpdir = createTmpdir;
        this.tmpdir = tmpdir;
        this.extraArguments = extraArguments;
        this.calc = calc == null ? new Metrics() : calc;
        this.recalc = recalc == null ? new Metrics() : recalc;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        String errorPrefix = "TICS Analysis failed with exit code: ";
        PrintStream logger = listener.getLogger();
        try {
            int exitCode;
            EnvVars buildEnv = run.getEnvironment(listener);
            if (!Strings.isNullOrEmpty((String)this.branchDirectory) && (exitCode = this.setBranchDirUsingTicsMaintenance(run, launcher, listener, buildEnv)) != 0) {
                logger.println("[TICS Analyzer] Exit code " + exitCode);
                throw new RuntimeException("[TICS Analyzer] TICS Analysis failed with exit code: " + exitCode);
            }
            exitCode = this.launchTicsQServer(run, launcher, listener, buildEnv);
            if (exitCode != 0) {
                logger.println("[TICS Analyzer] Exit code " + exitCode);
                throw new RuntimeException("[TICS Analyzer] TICS Analysis failed with exit code: " + exitCode);
            }
        }
        catch (IOException e) {
            logger.println(LOGGING_PREFIX + e.getMessage());
            throw e;
        }
    }

    private String getFullyQualifiedPath(String command) {
        String path = ((String)MoreObjects.firstNonNull((Object)this.ticsPath, (Object)"")).trim();
        if ("".equals(path)) {
            return command;
        }
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + "/";
        }
        return path + command;
    }

    private int setBranchDirUsingTicsMaintenance(Run run, Launcher launcher, TaskListener listener, EnvVars buildEnv) throws IOException, InterruptedException {
        ArrayList args = Lists.newArrayList();
        args.add(this.getFullyQualifiedPath("TICSMaintenance"));
        args.add("-project");
        args.add(Util.replaceMacro((String)this.projectName, (Map)buildEnv));
        args.add("-branchname");
        args.add(Util.replaceMacro((String)this.branchName, (Map)buildEnv));
        args.add("-branchdir");
        args.add(Util.replaceMacro((String)this.branchDirectory, (Map)buildEnv));
        Launcher.ProcStarter starter = new Launcher.ProcStarter(launcher).stdout(listener).cmds((List)args).envs(this.getEnvMap(buildEnv));
        Proc proc = launcher.launch(starter);
        int exitCode = proc.join();
        return exitCode;
    }

    int launchTicsQServer(Run run, Launcher launcher, TaskListener listener, EnvVars buildEnv) throws IOException, InterruptedException {
        ArgumentListBuilder args = new ArgumentListBuilder();
        args.add(this.getFullyQualifiedPath("TICSQServer"));
        if (TicsAnalyzer.isNotEmpty(this.projectName)) {
            args.add("-project");
            args.add(Util.replaceMacro((String)this.projectName, (Map)buildEnv));
        }
        if (TicsAnalyzer.isNotEmpty(this.branchName)) {
            args.add("-branchname");
            args.add(Util.replaceMacro((String)this.branchName, (Map)buildEnv));
        }
        if (this.createTmpdir && TicsAnalyzer.isNotEmpty(this.tmpdir)) {
            args.add("-tmpdir");
            args.add(Util.replaceMacro((String)this.tmpdir.trim(), (Map)buildEnv));
        }
        if (TicsAnalyzer.isNotEmpty(this.extraArguments)) {
            args.addTokenized(Util.replaceMacro((String)this.extraArguments.trim(), (Map)buildEnv));
        }
        this.addMetrics(args, "-calc", this.calc);
        this.addMetrics(args, "-recalc", this.recalc);
        Launcher.ProcStarter starter = new Launcher.ProcStarter(launcher).stdout(listener).cmds(args).envs(this.getEnvMap(buildEnv));
        Proc proc = launcher.launch(starter);
        int exitCode = proc.join();
        return exitCode;
    }

    private static boolean isNotEmpty(String arg) {
        return !"".equals(Strings.nullToEmpty((String)arg).trim());
    }

    void addMetrics(ArgumentListBuilder args, String key, Metrics metrics) {
        ImmutableList<String> names = metrics.getEnabledMetrics();
        if (!names.isEmpty()) {
            args.add(key);
            args.add(Joiner.on((String)",").join(names));
        }
    }

    Map<String, String> getEnvMap(EnvVars buildEnv) {
        LinkedHashMap out = Maps.newLinkedHashMap();
        ImmutableList lines = ImmutableList.copyOf((Iterable)Splitter.onPattern((String)"\r?\n").split((CharSequence)MoreObjects.firstNonNull((Object)this.environmentVariables, (Object)"")));
        for (String line : lines) {
            ArrayList splitted = Lists.newArrayList((Iterable)Splitter.on((String)"=").limit(2).split((CharSequence)line));
            if (splitted.size() != 2) continue;
            out.put(((String)splitted.get(0)).trim(), Util.replaceMacro((String)((String)splitted.get(1)).trim(), (Map)buildEnv));
        }
        if (TicsAnalyzer.isNotEmpty(this.ticsConfiguration)) {
            out.put("TICS", Util.replaceMacro((String)this.ticsConfiguration, (Map)buildEnv));
        }
        return out;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return "Run TICS";
        }

        public boolean isApplicable(Class type) {
            return true;
        }

        public boolean configure(StaplerRequest staplerRequest, JSONObject json) throws Descriptor.FormException {
            this.save();
            return true;
        }

        @POST
        public FormValidation doCheckProjectName(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null) {
                return FormValidation.ok();
            }
            item.checkPermission(Item.CONFIGURE);
            if ("".equals(Strings.nullToEmpty((String)value).trim())) {
                return FormValidation.error((String)"Please provide a project name");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckBranchName(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null) {
                return FormValidation.ok();
            }
            item.checkPermission(Item.CONFIGURE);
            if ("".equals(Strings.nullToEmpty((String)value).trim())) {
                return FormValidation.error((String)"Please provide a branch name");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckTmpdir(@AncestorInPath Item item, @QueryParameter String value, @QueryParameter boolean createTmpdir) {
            if (item == null) {
                return FormValidation.ok();
            }
            item.checkPermission(Item.CONFIGURE);
            if (createTmpdir && "".equals(Strings.nullToEmpty((String)value).trim())) {
                return FormValidation.error((String)"Please provide a directory");
            }
            return FormValidation.ok();
        }
    }
}

