/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tics;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import java.util.List;
import org.joda.time.Instant;

public class MeasureApiSuccessResponse<T> {
    public List<MetricValue<T>> data = Lists.newArrayList();
    public List<Metric> metrics = Lists.newArrayList();

    public static class Baseline {
        public String name;
        public String instant;

        public Instant getStarted() {
            return Instant.parse((String)this.instant);
        }

        public String getName() {
            return (String)MoreObjects.firstNonNull((Object)this.name, (Object)"?");
        }
    }

    public static class Run {
        public String started;

        public Instant getStarted() {
            return Instant.parse((String)this.started);
        }
    }

    public static class TqiVersion
    implements Comparable<TqiVersion> {
        public int major;
        public int minor;

        public TqiVersion(int major, int minor) {
            this.major = major;
            this.minor = minor;
        }

        public TqiVersion() {
        }

        @Override
        public int compareTo(TqiVersion that) {
            return ComparisonChain.start().compare(this.major, that.major).compare(this.minor, that.minor).result();
        }
    }

    public static class Metric {
        public String expression;
        public String fullName;

        public String getExpression() {
            return (String)MoreObjects.firstNonNull((Object)this.expression, (Object)"");
        }
    }

    public static class MetricValue<T> {
        public T value;
        public String letter;
        public String formattedValue;
    }
}

