/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.tics;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import hudson.plugins.tics.AbstractApiCall;
import hudson.plugins.tics.MeasureApiSuccessResponse;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.joda.time.Instant;

public class MeasureApiCall
extends AbstractApiCall {
    public static final TypeToken<MeasureApiSuccessResponse<Double>> RESPONSE_DOUBLE_TYPETOKEN = new TypeToken<MeasureApiSuccessResponse<Double>>(){};
    public static final TypeToken<MeasureApiSuccessResponse<MeasureApiSuccessResponse.TqiVersion>> RESPONSE_TQIVERSION_TYPETOKEN = new TypeToken<MeasureApiSuccessResponse<MeasureApiSuccessResponse.TqiVersion>>(){};
    public static final TypeToken<MeasureApiSuccessResponse<List<MeasureApiSuccessResponse.Run>>> RESPONSE_RUNS_TYPETOKEN = new TypeToken<MeasureApiSuccessResponse<List<MeasureApiSuccessResponse.Run>>>(){};
    public static final TypeToken<MeasureApiSuccessResponse<List<MeasureApiSuccessResponse.Baseline>>> RESPONSE_BASELINES_TYPETOKEN = new TypeToken<MeasureApiSuccessResponse<List<MeasureApiSuccessResponse.Baseline>>>(){};
    private final PrintStream logger;
    private final String measureApiUrl;

    public MeasureApiCall(PrintStream logger, String measureApiUrl, Optional<StandardUsernamePasswordCredentials> credentials) {
        super("[Measure API]", logger, credentials);
        Preconditions.checkState((boolean)measureApiUrl.endsWith("/Measure"));
        this.logger = logger;
        this.measureApiUrl = measureApiUrl;
    }

    public <T> T execute(TypeToken<T> typeToken, String paths, String metrics) throws MeasureApiCallException {
        return this.execute(typeToken, paths, metrics, Optional.empty());
    }

    public <T> T execute(TypeToken<T> typeToken, String paths, String metrics, Optional<Instant> date) throws MeasureApiCallException {
        String body;
        String url;
        URIBuilder builder;
        try {
            builder = new URIBuilder(this.measureApiUrl).setParameter("nodes", paths).setParameter("metrics", metrics);
        }
        catch (URISyntaxException e) {
            throw new MeasureApiCallException("Invalid URL: " + e.getMessage());
        }
        if (date.isPresent()) {
            long seconds = date.get().getMillis() / 1000L;
            builder = builder.setParameter("dates", "" + seconds);
        }
        try {
            url = builder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new MeasureApiCallException("Invalid URL: " + e.getMessage());
        }
        HttpGet httpGet = new HttpGet(url);
        this.logger.println("[TICS Publisher] " + httpGet.toString());
        try (CloseableHttpClient httpclient = this.createHttpClient();
             CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpGet);){
            body = EntityUtils.toString((HttpEntity)response.getEntity());
            this.throwIfStatusNotOk((HttpResponse)response, body);
        }
        catch (ConnectException e) {
            throw new MeasureApiCallException(e.getMessage());
        }
        catch (Exception e) {
            throw new MeasureApiCallException(e.toString());
        }
        try {
            Object t = new Gson().fromJson(body, typeToken.getType());
            return (T)t;
        }
        catch (JsonSyntaxException ex) {
            throw new RuntimeException("Error parsing json: " + body, ex);
        }
    }

    public static class MeasureApiCallException
    extends Exception {
        private final String message;

        public MeasureApiCallException(String message) {
            super(message);
            this.message = message;
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }
}

