/*
 * Decompiled with CFR 0.152.
 */
package com.thycotic.secrets.jenkins;

import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.thycotic.secrets.jenkins.ClientSecret;
import com.thycotic.secrets.jenkins.VaultConfiguration;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class VaultSecret
extends AbstractDescribableImpl<VaultSecret> {
    private final String path;
    private final List<Mapping> mappings;
    private String credentialId;
    private String tenant;
    private String tld;

    public String getPath() {
        return this.path;
    }

    public List<Mapping> getMappings() {
        return this.mappings;
    }

    @DataBoundConstructor
    public VaultSecret(String path, List<Mapping> mappings) {
        this.path = path;
        this.mappings = mappings;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    @DataBoundSetter
    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    public String getTenant() {
        return this.tenant;
    }

    @DataBoundSetter
    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public String getTld() {
        return this.tld;
    }

    @DataBoundSetter
    public void setTld(String tld) {
        this.tld = tld;
    }

    @Extension
    @Symbol(value={"devOpsVaultSecret"})
    public static final class DescriptorImpl
    extends Descriptor<VaultSecret> {
        public String getDisplayName() {
            return "DevOps Secrets Vault Secret";
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath Item item) {
            return new StandardListBoxModel().includeAs(ACL.SYSTEM, item, ClientSecret.class).includeEmptyValue();
        }
    }

    public static class Mapping
    extends AbstractDescribableImpl<Mapping> {
        private final String dataField;
        private final String environmentVariable;

        public String getDataField() {
            return this.dataField;
        }

        public String getEnvironmentVariable() {
            return this.environmentVariable;
        }

        @DataBoundConstructor
        public Mapping(String dataField, String environmentVariable) {
            this.dataField = dataField;
            this.environmentVariable = environmentVariable;
        }

        @Extension
        public static final class DescriptorImpl
        extends Descriptor<Mapping> {
            private static final String NAME_PATTERN = "[a-zA-Z_][a-zA-Z0-9]*";

            public String getDisplayName() {
                return "Secret Data Field to Environment Variable Mapping";
            }

            private FormValidation checkPattern(String value, String name) {
                if (Pattern.matches(NAME_PATTERN, value)) {
                    return FormValidation.ok();
                }
                return FormValidation.error((String)String.format("%s must match %s", name, NAME_PATTERN));
            }

            public FormValidation doCheckCredentialId(@QueryParameter String value) throws IOException, ServletException {
                if (StringUtils.isBlank((String)value) && StringUtils.isBlank((String)VaultConfiguration.get().getCredentialId())) {
                    return FormValidation.error((String)"Credentials are required");
                }
                return FormValidation.ok();
            }

            public FormValidation doCheckTenant(@QueryParameter String value) throws IOException, ServletException {
                if (StringUtils.isBlank((String)value) && StringUtils.isBlank((String)VaultConfiguration.get().getTenant())) {
                    return FormValidation.error((String)"Tenant is required");
                }
                return FormValidation.ok();
            }

            public FormValidation doCheckTld(@QueryParameter String value) throws IOException, ServletException {
                if (StringUtils.isBlank((String)value) && StringUtils.isBlank((String)VaultConfiguration.get().getTld())) {
                    return FormValidation.error((String)"TLD is required");
                }
                return FormValidation.ok();
            }

            public FormValidation doCheckEnvironmentVariable(@QueryParameter String value) throws IOException, ServletException {
                return this.checkPattern(value, "Environment Variable");
            }

            public FormValidation doCheckDataField(@QueryParameter String value) throws IOException, ServletException {
                return this.checkPattern(value, "Secret Field Name");
            }
        }
    }
}

