/*
 * Decompiled with CFR 0.152.
 */
package cz.mendelu.xotradov;

import cz.mendelu.xotradov.SimpleQueueConfig;
import cz.mendelu.xotradov.SimpleQueueSorter;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.model.queue.QueueSorter;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class UnsafeResetAction
implements RootAction {
    private static Logger logger = Logger.getLogger(UnsafeResetAction.class.getName());

    public void doReset(StaplerRequest request, StaplerResponse response) {
        if (!SimpleQueueConfig.getInstance().isEnableUnsafe()) {
            throw new IllegalArgumentException("Unsafe reset api attempted without being enabled");
        }
        UnsafeResetAction.resetImpl(request, response);
    }

    public static void resetImpl(StaplerRequest request, StaplerResponse response) {
        QueueSorter queueSorter = Jenkins.get().getQueue().getSorter();
        if (queueSorter instanceof SimpleQueueSorter) {
            ((SimpleQueueSorter)queueSorter).reset();
        }
        try {
            response.sendRedirect2(request.getRootPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    @CheckForNull
    public String getUrlName() {
        return "simpleQueueResetUnsafe";
    }
}

