/*
 * Decompiled with CFR 0.152.
 */
package cz.mendelu.xotradov;

import com.google.common.annotations.VisibleForTesting;
import hudson.model.Queue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;

public class SimpleQueueComparator
implements Comparator<Queue.BuildableItem> {
    private static Logger logger = Logger.getLogger(SimpleQueueComparator.class.getName());
    private Hashtable<Long, List<Long>> moveDesires = new Hashtable();

    public static SimpleQueueComparator getInstance() {
        return SimpleQueueComparatorHolder.INSTANCE;
    }

    public boolean hasDesiresFor(long key) {
        return this.moveDesires.containsKey(key);
    }

    @Override
    public int compare(Queue.BuildableItem buildableItem1, Queue.BuildableItem buildableItem2) {
        if (this.isFirstItemOverSecond(buildableItem1.getId(), buildableItem2.getId())) {
            return -1;
        }
        if (this.isFirstItemOverSecond(buildableItem2.getId(), buildableItem1.getId())) {
            return 1;
        }
        return 0;
    }

    private boolean isFirstItemOverSecond(long id0, long id1) {
        if (this.moveDesires.get(id0) != null) {
            return this.moveDesires.get(id0).contains(id1);
        }
        return false;
    }

    public void addDesire(long longA, long longB) {
        List<Object> bList;
        if (!this.moveDesires.containsKey(longA)) {
            bList = new ArrayList();
            this.moveDesires.put(longA, bList);
        } else {
            bList = this.moveDesires.get(longA);
        }
        if (bList != null) {
            if (bList.isEmpty()) {
                bList.add(longB);
            } else if (!bList.contains(longB)) {
                bList.add(longB);
            }
            List<Long> aList = this.moveDesires.get(longB);
            if (aList != null && aList.contains(longA)) {
                aList.remove(longA);
                if (aList.isEmpty()) {
                    this.moveDesires.remove(longB);
                }
            }
        }
    }

    @VisibleForTesting
    public void removeDesireOfKey(long id) {
        this.moveDesires.remove(id);
    }

    @VisibleForTesting
    public void resetDesires() {
        this.moveDesires.clear();
    }

    private static class SimpleQueueComparatorHolder {
        static final SimpleQueueComparator INSTANCE = new SimpleQueueComparator();

        private SimpleQueueComparatorHolder() {
        }
    }
}

