/*
 * Decompiled with CFR 0.152.
 */
package cz.mendelu.xotradov;

import cz.mendelu.xotradov.PermissionHandler;
import cz.mendelu.xotradov.SimpleQueueSorter;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.model.queue.QueueSorter;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Extension
public class ResetAction
implements RootAction {
    private static Logger logger = Logger.getLogger(ResetAction.class.getName());

    public void doReset(StaplerRequest request, StaplerResponse response) {
        if (!Jenkins.get().hasPermission(PermissionHandler.SIMPLE_QUEUE_RESET_PERMISSION)) {
            return;
        }
        QueueSorter queueSorter = Jenkins.get().getQueue().getSorter();
        if (queueSorter instanceof SimpleQueueSorter) {
            ((SimpleQueueSorter)queueSorter).reset();
        }
        try {
            response.sendRedirect2(request.getRootPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @CheckForNull
    public String getIconFileName() {
        if (Jenkins.get().hasPermission(PermissionHandler.SIMPLE_QUEUE_RESET_PERMISSION)) {
            return "/plugin/simple-queue/images/reset_64.png";
        }
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        if (Jenkins.get().hasPermission(PermissionHandler.SIMPLE_QUEUE_RESET_PERMISSION)) {
            return "Reset Simple-Queue";
        }
        return null;
    }

    @CheckForNull
    public String getUrlName() {
        if (Jenkins.get().hasPermission(PermissionHandler.SIMPLE_QUEUE_RESET_PERMISSION)) {
            return "simpleQueueReset";
        }
        return null;
    }
}

