/*
 * Decompiled with CFR 0.152.
 */
package redhat.jenkins.plugins.rhda.utils;

import java.io.IOException;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import redhat.jenkins.plugins.rhda.utils.CommandExecutor;

public class Utils {
    public static String doExecute(String cmd, PrintStream logger, Map<String, String> envs) {
        return new CommandExecutor().execute(cmd, logger, envs);
    }

    public static boolean isJSONValid(String test) {
        try {
            new JSONObject(test);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(test);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public static boolean urlExists(String urlStr) {
        int responseCode = 404;
        try {
            URL url = new URL(urlStr);
            HttpURLConnection huc = (HttpURLConnection)url.openConnection();
            responseCode = huc.getResponseCode();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 200 == responseCode;
    }

    public static String getOperatingSystem() {
        String os = System.getProperty("os.name");
        return os;
    }

    public static boolean isWindows() {
        String os = Utils.getOperatingSystem();
        return os.toLowerCase().contains("win");
    }

    public static boolean isLinux() {
        String os = Utils.getOperatingSystem();
        return os.toLowerCase().contains("lin");
    }

    public static boolean isMac() {
        String os = Utils.getOperatingSystem();
        return os.toLowerCase().contains("mac");
    }

    public static boolean is32() {
        return System.getProperty("sun.arch.data.model").equals("32");
    }

    public static boolean is64() {
        return System.getProperty("sun.arch.data.model").equals("64");
    }
}

