/*
 * Decompiled with CFR 0.152.
 */
package redhat.jenkins.plugins.rhda.task;

import com.redhat.exhort.Api;
import com.redhat.exhort.api.AnalysisReport;
import com.redhat.exhort.api.DependenciesSummary;
import com.redhat.exhort.api.ProviderStatus;
import com.redhat.exhort.api.VulnerabilitiesSummary;
import com.redhat.exhort.impl.ExhortApi;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.io.FileUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import redhat.jenkins.plugins.rhda.action.CRDAAction;
import redhat.jenkins.plugins.rhda.utils.RHDAGlobalConfig;

public class CRDABuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 1L;
    private String file;
    private boolean consentTelemetry = false;

    @DataBoundConstructor
    public CRDABuilder(String file, boolean consentTelemetry) {
        this.file = file;
        this.consentTelemetry = consentTelemetry;
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String file) {
        this.file = file;
    }

    public boolean getConsentTelemetry() {
        return this.consentTelemetry;
    }

    @DataBoundSetter
    public void setConsentTelemetry(boolean consentTelemetry) {
        this.consentTelemetry = consentTelemetry;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        String crdaUuid;
        PrintStream logger = listener.getLogger();
        RHDAGlobalConfig globalConfig = RHDAGlobalConfig.get();
        if (globalConfig == null) {
            globalConfig = new RHDAGlobalConfig();
        }
        if (globalConfig.getUuid() == null) {
            crdaUuid = UUID.randomUUID().toString();
            globalConfig.setUuid(crdaUuid);
        } else {
            crdaUuid = globalConfig.getUuid();
        }
        System.setProperty("RHDA_TOKEN", crdaUuid);
        System.setProperty("RHDA_SOURCE", "jenkins-plugin");
        logger.println("----- RHDA Analysis Begins -----");
        EnvVars envVars = this.getEnvVars(run, listener);
        System.setProperty("CONSENT_TELEMETRY", String.valueOf(this.getConsentTelemetry()));
        if (envVars != null) {
            if (envVars.get((Object)"EXHORT_MVN_PATH") != null) {
                System.setProperty("EXHORT_MVN_PATH", (String)envVars.get((Object)"EXHORT_MVN_PATH"));
            } else {
                System.clearProperty("EXHORT_MVN_PATH");
            }
            if (envVars.get((Object)"EXHORT_NPM_PATH") != null) {
                System.setProperty("EXHORT_NPM_PATH", (String)envVars.get((Object)"EXHORT_NPM_PATH"));
            } else {
                System.clearProperty("EXHORT_NPM_PATH");
            }
            if (envVars.get((Object)"EXHORT_GO_PATH") != null) {
                System.setProperty("EXHORT_GO_PATH", (String)envVars.get((Object)"EXHORT_GO_PATH"));
            } else {
                System.clearProperty("EXHORT_GO_PATH");
            }
            if (envVars.get((Object)"EXHORT_URL") != null) {
                System.setProperty("EXHORT_URL", (String)envVars.get((Object)"EXHORT_URL"));
            } else {
                System.clearProperty("EXHORT_URL");
            }
            if (envVars.get((Object)"EXHORT_SNYK_TOKEN") != null) {
                System.setProperty("EXHORT_SNYK_TOKEN", (String)envVars.get((Object)"EXHORT_SNYK_TOKEN"));
            } else {
                System.clearProperty("EXHORT_SNYK_TOKEN");
            }
            if (envVars.get((Object)"EXHORT_PYTHON3_PATH") != null) {
                System.setProperty("EXHORT_PYTHON3_PATH", (String)envVars.get((Object)"EXHORT_PYTHON3_PATH"));
            } else {
                System.clearProperty("EXHORT_PYTHON3_PATH");
            }
            if (envVars.get((Object)"EXHORT_PIP3_PATH") != null) {
                System.setProperty("EXHORT_PIP3_PATH", (String)envVars.get((Object)"EXHORT_PIP3_PATH"));
            } else {
                System.clearProperty("EXHORT_PIP3_PATH");
            }
            if (envVars.get((Object)"EXHORT_PYTHON_PATH") != null) {
                System.setProperty("EXHORT_PYTHON_PATH", (String)envVars.get((Object)"EXHORT_PYTHON_PATH"));
            } else {
                System.clearProperty("EXHORT_PYTHON_PATH");
            }
            if (envVars.get((Object)"EXHORT_PIP_PATH") != null) {
                System.setProperty("EXHORT_PIP_PATH", (String)envVars.get((Object)"EXHORT_PIP_PATH"));
            } else {
                System.clearProperty("EXHORT_PIP_PATH");
            }
        }
        System.setProperty("hudson.model.DirectoryBrowserSupport.CSP", "");
        Path manifestPath = Paths.get(this.getFile(), new String[0]);
        if (manifestPath.getParent() == null) {
            manifestPath = Paths.get(workspace.child(this.getFile()).toURI());
        }
        if (!Files.exists(manifestPath, new LinkOption[0])) {
            throw new FileNotFoundException("The specified file or path does not exist or is inaccessible. Please configure the build properly and retry.");
        }
        ExhortApi exhortApi = new ExhortApi();
        CompletableFuture mixedStackReport = exhortApi.stackAnalysisMixed(manifestPath.toString());
        try {
            this.processReport(((Api.MixedReport)mixedStackReport.get()).json, listener);
            this.saveHtmlReport(((Api.MixedReport)mixedStackReport.get()).html, listener, workspace);
            ArtifactArchiver archiver = new ArtifactArchiver("dependency-analytics-report.html");
            archiver.perform(run, workspace, envVars, launcher, listener);
            logger.println("Click on the RHDA Stack Report icon to view the detailed report.");
            logger.println("----- RHDA Analysis Ends -----");
            run.addAction((Action)new CRDAAction(crdaUuid, ((Api.MixedReport)mixedStackReport.get()).json, String.valueOf(workspace) + "/dependency-analysis-report.html", "freestyle"));
        }
        catch (ExecutionException e) {
            logger.println("error");
            e.printStackTrace(logger);
            e.printStackTrace();
        }
    }

    private EnvVars getEnvVars(Run<?, ?> run, TaskListener listener) {
        if (run == null || listener == null) {
            return null;
        }
        try {
            return run.getEnvironment(listener);
        }
        catch (IOException | InterruptedException e) {
            return null;
        }
    }

    private void processReport(AnalysisReport report, TaskListener listener) throws ExecutionException, InterruptedException {
        PrintStream logger = listener.getLogger();
        DependenciesSummary dependenciesSummary = report.getSummary().getDependencies();
        VulnerabilitiesSummary vulnerabilitiesSummary = report.getSummary().getVulnerabilities();
        for (ProviderStatus providerStatus : report.getSummary().getProviderStatuses()) {
            if (providerStatus.getStatus() == 200) continue;
            logger.println("WARNING: " + providerStatus.getProvider() + ": " + providerStatus.getMessage());
        }
        logger.println("Summary");
        logger.println("  Dependencies");
        logger.println("    Scanned dependencies:    " + dependenciesSummary.getScanned());
        logger.println("    Transitive dependencies: " + dependenciesSummary.getTransitive());
        logger.println("  Vulnerabilities");
        logger.println("    Total: " + vulnerabilitiesSummary.getTotal());
        logger.println("    Direct: " + vulnerabilitiesSummary.getDirect());
        logger.println("    Critical: " + vulnerabilitiesSummary.getCritical());
        logger.println("    High: " + vulnerabilitiesSummary.getHigh());
        logger.println("    Medium: " + vulnerabilitiesSummary.getMedium());
        logger.println("    Low: " + vulnerabilitiesSummary.getLow());
        logger.println("");
    }

    private void saveHtmlReport(byte[] html, TaskListener listener, FilePath workspace) throws IOException, InterruptedException {
        PrintStream logger = listener.getLogger();
        File file = new File(String.valueOf(workspace) + "/dependency-analytics-report.html");
        FileUtils.writeByteArrayToFile((File)file, (byte[])html);
        logger.println("You can find the latest detailed HTML report in your workspace and in your build under Build Artifacts.");
    }

    @Extension
    public static final class BuilderDescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public BuilderDescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckFile(@QueryParameter String file) {
            if (file.length() == 0) {
                return FormValidation.error((String)"Manifest file location cannot be empty");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Invoke Red Hat Dependency Analysis (RHDA)";
        }
    }
}

