/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import io.jenkins.plugins.prism.PermittedSourceCodeDirectory;
import io.jenkins.plugins.prism.PrismAppearanceConfiguration;
import io.jenkins.plugins.prism.PrismTheme;
import io.jenkins.plugins.util.GlobalConfigurationFacade;
import io.jenkins.plugins.util.GlobalConfigurationItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.model.GlobalConfigurationCategory;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;

@Extension
@Symbol(value={"prism"})
public class PrismConfiguration
extends GlobalConfigurationItem {
    private static final PathUtil PATH_UTIL = new PathUtil();
    private List<PermittedSourceCodeDirectory> sourceDirectories = Collections.emptyList();
    private Set<String> normalizedSourceDirectories = Collections.emptySet();
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"}, justification="Kept for compatibility")
    private transient PrismTheme theme;

    public PrismConfiguration() {
        this.load();
    }

    @VisibleForTesting
    PrismConfiguration(GlobalConfigurationFacade facade) {
        super(facade);
        this.load();
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    protected void clearRepeatableProperties() {
        this.setSourceDirectories(new ArrayList<PermittedSourceCodeDirectory>());
    }

    public static PrismConfiguration getInstance() {
        return (PrismConfiguration)((Object)PrismConfiguration.all().get(PrismConfiguration.class));
    }

    public List<PermittedSourceCodeDirectory> getSourceDirectories() {
        return this.sourceDirectories;
    }

    @DataBoundSetter
    public void setSourceDirectories(List<PermittedSourceCodeDirectory> sourceDirectories) {
        this.sourceDirectories = new ArrayList<PermittedSourceCodeDirectory>(sourceDirectories);
        this.normalizedSourceDirectories = sourceDirectories.stream().map(PermittedSourceCodeDirectory::getPath).map(arg_0 -> ((PathUtil)PATH_UTIL).getAbsolutePath(arg_0)).collect(Collectors.toSet());
        this.save();
    }

    @Deprecated
    public PrismTheme getTheme() {
        return PrismAppearanceConfiguration.getInstance().getTheme();
    }

    public boolean isAllowedSourceDirectory(String sourceDirectory) {
        return this.normalizedSourceDirectories.contains(PATH_UTIL.getAbsolutePath(sourceDirectory));
    }
}

