/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import com.google.errorprone.annotations.FormatMethod;
import java.io.PrintStream;
import java.util.Collection;

public class PrefixLogger {
    private final String toolName;
    private final PrintStream delegate;

    public PrefixLogger(PrintStream logger, String prefix) {
        this.toolName = prefix.contains("[") ? prefix + " " : "[%s] ".formatted(prefix);
        this.delegate = logger;
    }

    @FormatMethod
    public void log(String format, Object ... args) {
        this.print(format.formatted(args));
    }

    public void logEachLine(Collection<String> lines) {
        lines.forEach(this::print);
    }

    private void print(String line) {
        this.delegate.println(this.toolName + line);
    }
}

