/*
 * Decompiled with CFR 0.152.
 */
package io.plugins.perfecto;

import hudson.model.AbstractProject;
import hudson.model.BuildableItemWithBuildWrappers;
import io.plugins.perfecto.PerfectoBuildWrapper;
import java.util.Map;
import java.util.logging.Logger;

public final class PerfectoEnvironmentUtil {
    private static final Logger logger = Logger.getLogger(PerfectoEnvironmentUtil.class.getName());

    private PerfectoEnvironmentUtil() {
    }

    public static void outputEnvironmentVariable(Map<String, String> env, String key, String value, boolean overwrite) {
        if (env.get(key) == null || overwrite) {
            env.put(key, value);
        }
    }

    public static PerfectoBuildWrapper getBuildWrapper(AbstractProject<?, ?> project) {
        PerfectoBuildWrapper buildWrapper = null;
        if (project instanceof BuildableItemWithBuildWrappers) {
            buildWrapper = (PerfectoBuildWrapper)((BuildableItemWithBuildWrappers)project).getBuildWrappersList().get(PerfectoBuildWrapper.class);
        } else {
            logger.fine("Project is not a BuildableItemWithBuildWrappers instance " + project.toString());
        }
        if (buildWrapper == null) {
            logger.fine("Could not find PerfectoBuildWrapper on project " + project.toString());
        }
        return buildWrapper;
    }
}

