/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector;

import com.google.common.base.Strings;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.neuvector.Config;
import io.jenkins.plugins.neuvector.Messages;
import io.jenkins.plugins.neuvector.NeuVectorBuilder;
import io.jenkins.plugins.neuvector.NeuVectorWorker;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class ControllerEndpointUrl
extends AbstractDescribableImpl<ControllerEndpointUrl>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String nickname;
    private String controllerEndpointUrl;
    private String protocol;
    private String host;
    private Integer port;
    private String subpath;
    private String controllerUser;
    private Secret controllerPassword;
    private Integer timeout;
    private Boolean disableTLSCertVerification;
    private Boolean disableAPIKeyVerification;
    private String serverCertificate;
    private Secret serverApiKey;

    @DataBoundConstructor
    public ControllerEndpointUrl(String nickname, String controllerEndpointUrl, String controllerUser, Secret controllerPassword, Boolean disableTLSCertVerification, Boolean disableAPIKeyVerification, String serverCertificate, Integer timeout, Secret serverApiKey) throws URISyntaxException {
        this.nickname = nickname.trim();
        URI uri = new URI(controllerEndpointUrl);
        this.controllerEndpointUrl = controllerEndpointUrl;
        this.protocol = uri.getScheme();
        this.host = uri.getHost();
        this.port = uri.getPort() == -1 ? 443 : uri.getPort();
        this.subpath = uri.getPath();
        this.controllerUser = controllerUser.trim();
        this.controllerPassword = controllerPassword;
        this.timeout = timeout == null ? Integer.valueOf(0) : timeout;
        this.disableTLSCertVerification = disableTLSCertVerification;
        this.disableAPIKeyVerification = disableAPIKeyVerification;
        this.serverCertificate = serverCertificate;
        this.serverApiKey = serverApiKey;
    }

    public String getControllerEndpointUrl() {
        return this.controllerEndpointUrl;
    }

    public void setControllerEndpointUrl(String controllerEndpointUrl) {
        this.controllerEndpointUrl = controllerEndpointUrl;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getSubpath() {
        return this.subpath;
    }

    public void setSubpath(String subpath) {
        this.subpath = subpath;
    }

    public String getControllerUser() {
        return this.controllerUser;
    }

    public void setControllerUser(String controllerUser) {
        this.controllerUser = controllerUser;
    }

    public Secret getControllerPassword() {
        return this.controllerPassword;
    }

    public void setControllerPassword(Secret controllerPassword) {
        this.controllerPassword = controllerPassword;
    }

    public Boolean getDisableTLSCertVerification() {
        return this.disableTLSCertVerification;
    }

    public void setDisableTLSCertVerification(Boolean disableTLSCertVerification) {
        this.disableTLSCertVerification = disableTLSCertVerification;
    }

    public Boolean getDisableAPIKeyVerification() {
        return this.disableAPIKeyVerification;
    }

    public void setDisableAPIKeyVerification(Boolean disableAPIKeyVerification) {
        this.disableAPIKeyVerification = disableAPIKeyVerification;
    }

    public String getServerCertificate() {
        return this.serverCertificate;
    }

    public void setServerCertificate(String serverCertificate) {
        this.serverCertificate = serverCertificate;
    }

    public Secret getServerApiKey() {
        return this.serverApiKey;
    }

    public void setServerApiKey(Secret serverApiKey) {
        this.serverApiKey = serverApiKey;
    }

    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public String toString() {
        StringBuilder apiUrlBuilder = new StringBuilder();
        apiUrlBuilder.append(this.protocol).append("://").append(this.host).append(":").append(this.port).append(this.subpath);
        return apiUrlBuilder.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ControllerEndpointUrl> {
        private final NeuVectorBuilder.DescriptorImpl globalConfig = (NeuVectorBuilder.DescriptorImpl)Jenkins.get().getDescriptorByType(NeuVectorBuilder.DescriptorImpl.class);

        public String getDisplayName() {
            return "Add ControllerEndpointUrl";
        }

        public FormValidation doCheckNickname(@QueryParameter String nickname) {
            if (Strings.isNullOrEmpty((String)nickname) || nickname.trim().isEmpty()) {
                return FormValidation.error((String)Messages.Registry_DescriptorImpl_errors_nickname());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckControllerEndpointUrl(@QueryParameter String value) {
            if (value != null && !value.trim().isEmpty() && !value.trim().matches("^https://([a-zA-Z0-9.-]+)(:([0-9]+))?(/[a-zA-Z0-9./-]+)?$")) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_controllerApiUrl());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            try {
                if (Integer.parseInt(value) < 0) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_timeout());
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_timeout());
            }
        }

        public FormValidation doDeleteRegistry(@QueryParameter String nickname, @QueryParameter String controllerEndpointUrl, @QueryParameter String controllerUser) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            List<ControllerEndpointUrl> controllerEndpointUrls = this.globalConfig.getControllerEndpointUrls();
            Iterator<ControllerEndpointUrl> iterator = controllerEndpointUrls.iterator();
            while (iterator.hasNext()) {
                ControllerEndpointUrl endpoint = iterator.next();
                if (!endpoint.getNickname().equals(nickname)) continue;
                iterator.remove();
                this.globalConfig.save();
            }
            return FormValidation.ok((String)"Deleted successfully");
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="nickname") String nickname, @QueryParameter(value="controllerEndpointUrl") String controllerEndpointUrl, @QueryParameter(value="controllerUser") String controllerUser, @QueryParameter(value="controllerPassword") Secret controllerPassword, @QueryParameter(value="disableTLSCertVerification") Boolean disableTLSCertVerification, @QueryParameter(value="disableAPIKeyVerification") Boolean disableAPIKeyVerification, @QueryParameter(value="serverCertificate") String serverCertificate, @QueryParameter(value="serverApiKey") Secret serverApiKey, @QueryParameter(value="uuid") String uuid) throws URISyntaxException {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            Config config = new Config.ConfigBuilder(nickname, controllerEndpointUrl, controllerUser, controllerPassword, disableTLSCertVerification, disableAPIKeyVerification, serverCertificate, 0, serverApiKey).build();
            NeuVectorWorker worker = new NeuVectorWorker(null, config);
            try {
                if (disableAPIKeyVerification.booleanValue()) {
                    worker.testConnection();
                } else {
                    worker.testApiKey();
                }
                return FormValidation.ok((String)"Connection Success");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Failed to connect " + controllerEndpointUrl + ". " + e.getMessage()));
            }
        }
    }
}

