/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector;

import hudson.util.Secret;
import io.jenkins.plugins.neuvector.ControllerEndpointUrl;
import io.jenkins.plugins.neuvector.Registry;
import io.jenkins.plugins.neuvector.model.ScanMeta;
import java.net.URISyntaxException;

public class Config {
    private ScanMeta scanMeta;
    private ControllerEndpointUrl controllerApiUrl;
    private String user;
    private String password;
    private int timeout;
    private boolean standaloneScanner;
    private boolean sendReportToController;
    private boolean isLocal;
    private String scannerRegistryURL;
    private String scannerImage;
    private boolean disableTLSCertVerification;
    private String serverCertificate;
    private String scannerRegistryUser;
    private Secret scannerRegistryPassword;
    private Double mediumSeverityThreshold;
    private Double highSeverityThreshold;
    private boolean customizedRatingScale;
    private Registry registry;
    private String repository;
    private String tag;
    private boolean scanLayers;
    private String numberOfHighSeverityToFail;
    private String numberOfMediumSeverityToFail;
    private String nameOfVulnerabilityToFailOne;
    private String nameOfVulnerabilityToFailTwo;
    private String nameOfVulnerabilityToFailThree;
    private String nameOfVulnerabilityToFailFour;
    private String nameOfVulnerabilityToExemptOne;
    private String nameOfVulnerabilityToExemptTwo;
    private String nameOfVulnerabilityToExemptThree;
    private String nameOfVulnerabilityToExemptFour;
    private Integer scanTimeout;

    private Config(ConfigBuilder builder) {
        this.scanMeta = builder.scanMeta;
        this.controllerApiUrl = builder.controllerApiUrl;
        this.user = builder.user;
        this.password = builder.password;
        this.timeout = builder.timeout;
        this.standaloneScanner = builder.standaloneScanner;
        this.sendReportToController = builder.sendReportToController;
        this.isLocal = builder.isLocal;
        this.scannerRegistryURL = builder.scannerRegistryURL;
        this.scannerRegistryUser = builder.scannerRegistryUser;
        this.scannerRegistryPassword = builder.scannerRegistryPassword;
        this.scannerImage = builder.scannerImage;
        this.disableTLSCertVerification = builder.disableTLSCertVerification;
        this.serverCertificate = builder.serverCertificate;
        this.highSeverityThreshold = builder.highSeverityThreshold;
        this.mediumSeverityThreshold = builder.mediumSeverityThreshold;
        this.customizedRatingScale = builder.customizedRatingScale;
        this.registry = builder.registry;
        this.repository = builder.repository;
        this.tag = builder.tag;
        this.scanLayers = builder.scanLayers;
        this.scanTimeout = builder.scanTimeout;
        this.numberOfHighSeverityToFail = builder.numberOfHighSeverityToFail;
        this.numberOfMediumSeverityToFail = builder.numberOfMediumSeverityToFail;
        this.nameOfVulnerabilityToFailOne = builder.nameOfVulnerabilityToFailOne;
        this.nameOfVulnerabilityToFailTwo = builder.nameOfVulnerabilityToFailTwo;
        this.nameOfVulnerabilityToFailThree = builder.nameOfVulnerabilityToFailThree;
        this.nameOfVulnerabilityToFailFour = builder.nameOfVulnerabilityToFailFour;
        this.nameOfVulnerabilityToExemptOne = builder.nameOfVulnerabilityToExemptOne;
        this.nameOfVulnerabilityToExemptTwo = builder.nameOfVulnerabilityToExemptTwo;
        this.nameOfVulnerabilityToExemptThree = builder.nameOfVulnerabilityToExemptThree;
        this.nameOfVulnerabilityToExemptFour = builder.nameOfVulnerabilityToExemptFour;
    }

    public ScanMeta getScanMeta() {
        return this.scanMeta;
    }

    public ControllerEndpointUrl getControllerApiUrl() {
        return this.controllerApiUrl;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isStandaloneScanner() {
        return this.standaloneScanner;
    }

    public boolean isSendReportToController() {
        return this.sendReportToController;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String getScannerRegistryURL() {
        return this.scannerRegistryURL;
    }

    public String getScannerRegistryUser() {
        return this.scannerRegistryUser;
    }

    public Secret getScannerRegistryPassword() {
        return this.scannerRegistryPassword;
    }

    public String getScannerImage() {
        return this.scannerImage;
    }

    public boolean getDisableTLSCertVerification() {
        return this.disableTLSCertVerification;
    }

    public String getServerCertificate() {
        return this.serverCertificate;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean getScanLayers() {
        return this.scanLayers;
    }

    public Integer getScanTimeout() {
        return this.scanTimeout == null || this.scanTimeout <= 0 ? Integer.valueOf(10) : this.scanTimeout;
    }

    public String getNumberOfHighSeverityToFail() {
        return this.numberOfHighSeverityToFail;
    }

    public String getNumberOfMediumSeverityToFail() {
        return this.numberOfMediumSeverityToFail;
    }

    public String getNameOfVulnerabilityToFailOne() {
        return this.nameOfVulnerabilityToFailOne;
    }

    public String getNameOfVulnerabilityToFailTwo() {
        return this.nameOfVulnerabilityToFailTwo;
    }

    public String getNameOfVulnerabilityToFailThree() {
        return this.nameOfVulnerabilityToFailThree;
    }

    public String getNameOfVulnerabilityToFailFour() {
        return this.nameOfVulnerabilityToFailFour;
    }

    public String getNameOfVulnerabilityToExemptOne() {
        return this.nameOfVulnerabilityToExemptOne;
    }

    public String getNameOfVulnerabilityToExemptTwo() {
        return this.nameOfVulnerabilityToExemptTwo;
    }

    public String getNameOfVulnerabilityToExemptThree() {
        return this.nameOfVulnerabilityToExemptThree;
    }

    public String getNameOfVulnerabilityToExemptFour() {
        return this.nameOfVulnerabilityToExemptFour;
    }

    public boolean getCustomizedRatingScale() {
        return this.customizedRatingScale;
    }

    public Double getMediumSeverityThreshold() {
        return this.mediumSeverityThreshold;
    }

    public Double getHighSeverityThreshold() {
        return this.highSeverityThreshold;
    }

    public static class ConfigBuilder {
        private ScanMeta scanMeta;
        private final ControllerEndpointUrl controllerApiUrl;
        private final String user;
        private final String password;
        private int timeout;
        private boolean standaloneScanner;
        private boolean sendReportToController;
        private boolean isLocal;
        private String scannerRegistryURL;
        private String scannerImage;
        private boolean disableTLSCertVerification;
        private String serverCertificate;
        private String scannerRegistryUser;
        private Secret scannerRegistryPassword;
        private Double mediumSeverityThreshold;
        private Double highSeverityThreshold;
        private boolean customizedRatingScale;
        private Registry registry;
        private String repository;
        private String tag;
        private boolean scanLayers;
        private Integer scanTimeout;
        private String numberOfHighSeverityToFail;
        private String numberOfMediumSeverityToFail;
        private String nameOfVulnerabilityToFailOne;
        private String nameOfVulnerabilityToFailTwo;
        private String nameOfVulnerabilityToFailThree;
        private String nameOfVulnerabilityToFailFour;
        private String nameOfVulnerabilityToExemptOne;
        private String nameOfVulnerabilityToExemptTwo;
        private String nameOfVulnerabilityToExemptThree;
        private String nameOfVulnerabilityToExemptFour;

        public ConfigBuilder(String nickname, String controllerEndpointUrl, String user, Secret password, Boolean disableTLSCertVerification, String serverCertificate, int timeout) throws URISyntaxException {
            this.controllerApiUrl = new ControllerEndpointUrl(nickname, controllerEndpointUrl, user, password, disableTLSCertVerification, serverCertificate, timeout);
            this.user = user;
            this.password = password.getPlainText();
            this.disableTLSCertVerification = disableTLSCertVerification;
            this.serverCertificate = serverCertificate;
            this.timeout = timeout;
        }

        public ConfigBuilder(ControllerEndpointUrl controllerEndpointUrl) throws URISyntaxException {
            if (controllerEndpointUrl != null) {
                this.controllerApiUrl = controllerEndpointUrl;
                this.user = controllerEndpointUrl.getControllerUser();
                this.password = controllerEndpointUrl.getControllerPassword().getPlainText();
                this.disableTLSCertVerification = controllerEndpointUrl.getDisableTLSCertVerification();
                this.serverCertificate = controllerEndpointUrl.getServerCertificate();
                this.timeout = controllerEndpointUrl.getTimeout();
            } else {
                this.controllerApiUrl = null;
                this.user = null;
                this.password = null;
                this.disableTLSCertVerification = false;
                this.serverCertificate = null;
                this.timeout = 0;
            }
        }

        public Config build() {
            Config config = new Config(this);
            return config;
        }

        public ConfigBuilder scanMeta(ScanMeta scanMeta) {
            this.scanMeta = scanMeta;
            return this;
        }

        public ConfigBuilder standaloneScanner(boolean standaloneScanner) {
            this.standaloneScanner = standaloneScanner;
            return this;
        }

        public ConfigBuilder sendReportToController(boolean sendReportToController) {
            this.sendReportToController = sendReportToController;
            return this;
        }

        public ConfigBuilder isLocal(boolean isLocal) {
            this.isLocal = isLocal;
            return this;
        }

        public ConfigBuilder scannerRegistryURL(String scannerRegistryURL) {
            this.scannerRegistryURL = scannerRegistryURL;
            return this;
        }

        public ConfigBuilder scannerImage(String scannerImage) {
            this.scannerImage = scannerImage;
            return this;
        }

        public ConfigBuilder scannerRegistryUser(String scannerRegistryUser) {
            this.scannerRegistryUser = scannerRegistryUser;
            return this;
        }

        public ConfigBuilder scannerRegistryPassword(Secret scannerRegistryPassword) {
            this.scannerRegistryPassword = scannerRegistryPassword;
            return this;
        }

        public ConfigBuilder customizedRatingScale(boolean value) {
            this.customizedRatingScale = value;
            return this;
        }

        public ConfigBuilder highSeverityThreshold(Double value) {
            this.highSeverityThreshold = value;
            return this;
        }

        public ConfigBuilder mediumSeverityThreshold(Double value) {
            this.mediumSeverityThreshold = value;
            return this;
        }

        public ConfigBuilder registry(Registry registry) {
            this.registry = registry;
            return this;
        }

        public ConfigBuilder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public ConfigBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public ConfigBuilder scanLayers(boolean scanLayers) {
            this.scanLayers = scanLayers;
            return this;
        }

        public ConfigBuilder scanTimeout(Integer scanTimeout) {
            this.scanTimeout = scanTimeout;
            return this;
        }

        public ConfigBuilder numberOfHighSeverityToFail(String numberOfHighSeverityToFail) {
            this.numberOfHighSeverityToFail = numberOfHighSeverityToFail;
            return this;
        }

        public ConfigBuilder numberOfMediumSeverityToFail(String numberOfMediumSeverityToFail) {
            this.numberOfMediumSeverityToFail = numberOfMediumSeverityToFail;
            return this;
        }

        public ConfigBuilder nameOfVulnerabilityToFailOne(String nameOfVulnerabilityToFailOne) {
            this.nameOfVulnerabilityToFailOne = nameOfVulnerabilityToFailOne;
            return this;
        }

        public ConfigBuilder nameOfVulnerabilityToFailTwo(String nameOfVulnerabilityToFailTwo) {
            this.nameOfVulnerabilityToFailTwo = nameOfVulnerabilityToFailTwo;
            return this;
        }

        public ConfigBuilder nameOfVulnerabilityToFailThree(String nameOfVulnerabilityToFailThree) {
            this.nameOfVulnerabilityToFailThree = nameOfVulnerabilityToFailThree;
            return this;
        }

        public ConfigBuilder nameOfVulnerabilityToFailFour(String nameOfVulnerabilityToFailFour) {
            this.nameOfVulnerabilityToFailFour = nameOfVulnerabilityToFailFour;
            return this;
        }

        public ConfigBuilder nameOfVulnerabilityToExemptOne(String nameOfVulnerabilityToExemptOne) {
            this.nameOfVulnerabilityToExemptOne = nameOfVulnerabilityToExemptOne;
            return this;
        }

        public ConfigBuilder nameOfVulnerabilityToExemptTwo(String nameOfVulnerabilityToExemptTwo) {
            this.nameOfVulnerabilityToExemptTwo = nameOfVulnerabilityToExemptTwo;
            return this;
        }

        public ConfigBuilder nameOfVulnerabilityToExemptThree(String nameOfVulnerabilityToExemptThree) {
            this.nameOfVulnerabilityToExemptThree = nameOfVulnerabilityToExemptThree;
            return this;
        }

        public ConfigBuilder nameOfVulnerabilityToExemptFour(String nameOfVulnerabilityToExemptFour) {
            this.nameOfVulnerabilityToExemptFour = nameOfVulnerabilityToExemptFour;
            return this;
        }
    }
}

