/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector;

import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.neuvector.Config;
import io.jenkins.plugins.neuvector.Log;
import io.jenkins.plugins.neuvector.Messages;
import io.jenkins.plugins.neuvector.NeuVectorAction;
import io.jenkins.plugins.neuvector.NeuVectorWorker;
import io.jenkins.plugins.neuvector.Registry;
import io.jenkins.plugins.neuvector.model.ScanMeta;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;

public class NeuVectorBuilder
extends Builder
implements SimpleBuildStep {
    private static final String REGISTRY_DROPDOWN_DEFAULT = "Please select a registry:";
    private boolean standaloneScanner;
    private final String repository;
    private String tag;
    private boolean scanLayers;
    private String numberOfHighSeverityToFail;
    private String numberOfMediumSeverityToFail;
    private String nameOfVulnerabilityToFailOne;
    private String nameOfVulnerabilityToFailTwo;
    private String nameOfVulnerabilityToFailThree;
    private String nameOfVulnerabilityToFailFour;
    private String nameOfVulnerabilityToExemptOne;
    private String nameOfVulnerabilityToExemptTwo;
    private String nameOfVulnerabilityToExemptThree;
    private String nameOfVulnerabilityToExemptFour;
    private Integer scanTimeout;
    private final String registrySelection;
    private static int buildStep;
    private static int buildHash;
    private Log logger;

    public static synchronized void setBuildStep(int buildStep) {
        NeuVectorBuilder.buildStep = buildStep;
    }

    public static synchronized void setBuildHash(int buildHash) {
        NeuVectorBuilder.buildHash = buildHash;
    }

    @DataBoundConstructor
    public NeuVectorBuilder(String repository, String registrySelection) {
        this.repository = repository;
        this.registrySelection = registrySelection;
    }

    public boolean getStandaloneScanner() {
        return this.standaloneScanner;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean getScanLayers() {
        return this.scanLayers;
    }

    public Integer getScanTimeout() {
        return this.scanTimeout;
    }

    public String getNumberOfHighSeverityToFail() {
        return this.numberOfHighSeverityToFail;
    }

    public String getNumberOfMediumSeverityToFail() {
        return this.numberOfMediumSeverityToFail;
    }

    public String getNameOfVulnerabilityToFailOne() {
        return this.nameOfVulnerabilityToFailOne;
    }

    public String getNameOfVulnerabilityToFailTwo() {
        return this.nameOfVulnerabilityToFailTwo;
    }

    public String getNameOfVulnerabilityToFailThree() {
        return this.nameOfVulnerabilityToFailThree;
    }

    public String getNameOfVulnerabilityToFailFour() {
        return this.nameOfVulnerabilityToFailFour;
    }

    public String getNameOfVulnerabilityToExemptOne() {
        return this.nameOfVulnerabilityToExemptOne;
    }

    public String getNameOfVulnerabilityToExemptTwo() {
        return this.nameOfVulnerabilityToExemptTwo;
    }

    public String getNameOfVulnerabilityToExemptThree() {
        return this.nameOfVulnerabilityToExemptThree;
    }

    public String getNameOfVulnerabilityToExemptFour() {
        return this.nameOfVulnerabilityToExemptFour;
    }

    public String getRegistrySelection() {
        return this.registrySelection;
    }

    @DataBoundSetter
    public void setStandaloneScanner(boolean standaloneScanner) {
        this.standaloneScanner = standaloneScanner;
    }

    @DataBoundSetter
    public void setTag(String tag) {
        this.tag = tag.trim();
    }

    @DataBoundSetter
    public void setScanLayers(boolean scanLayers) {
        this.scanLayers = scanLayers;
    }

    @DataBoundSetter
    public void setScanTimeout(int scanTimeout) {
        this.scanTimeout = scanTimeout;
    }

    @DataBoundSetter
    public void setNumberOfHighSeverityToFail(String numberOfHighSeverityToFail) {
        this.numberOfHighSeverityToFail = numberOfHighSeverityToFail.trim();
    }

    @DataBoundSetter
    public void setNumberOfMediumSeverityToFail(String numberOfMediumSeverityToFail) {
        this.numberOfMediumSeverityToFail = numberOfMediumSeverityToFail.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailOne(String nameOfVulnerabilityToFailOne) {
        this.nameOfVulnerabilityToFailOne = nameOfVulnerabilityToFailOne.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailTwo(String nameOfVulnerabilityToFailTwo) {
        this.nameOfVulnerabilityToFailTwo = nameOfVulnerabilityToFailTwo.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailThree(String nameOfVulnerabilityToFailThree) {
        this.nameOfVulnerabilityToFailThree = nameOfVulnerabilityToFailThree.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailFour(String nameOfVulnerabilityToFailFour) {
        this.nameOfVulnerabilityToFailFour = nameOfVulnerabilityToFailFour.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToExemptOne(String nameOfVulnerabilityToExemptOne) {
        this.nameOfVulnerabilityToExemptOne = nameOfVulnerabilityToExemptOne.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToExemptTwo(String nameOfVulnerabilityToExemptTwo) {
        this.nameOfVulnerabilityToExemptTwo = nameOfVulnerabilityToExemptTwo.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToExemptThree(String nameOfVulnerabilityToExemptThree) {
        this.nameOfVulnerabilityToExemptThree = nameOfVulnerabilityToExemptThree.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToExemptFour(String nameOfVulnerabilityToExemptFour) {
        this.nameOfVulnerabilityToExemptFour = nameOfVulnerabilityToExemptFour.trim();
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        this.logger = new Log(listener.getLogger());
        EnvVars env = run.getEnvironment(listener);
        FilePath targetCss = new FilePath(workspace, "styles.css");
        File cssFile = new File((String)env.get((Object)"JENKINS_HOME") + "/plugins/neuvector-vulnerability-scanner/css/", "styles.css");
        FilePath cssFilePath = new FilePath(cssFile);
        cssFilePath.copyTo(targetCss);
        String artifactName = "NeuVectorReport_" + run.getParent().getDisplayName() + "_" + run.getNumber();
        if (run.hashCode() != buildHash) {
            NeuVectorBuilder.setBuildHash(run.hashCode());
            NeuVectorBuilder.setBuildStep(1);
        } else {
            NeuVectorBuilder.setBuildStep(buildStep + 1);
        }
        String reportNumber = Integer.toString(buildStep);
        artifactName = artifactName + "-" + reportNumber;
        Config config = null;
        try {
            config = this.printInfoFromUser(run, listener);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        NeuVectorWorker worker = new NeuVectorWorker(this.logger, config, workspace, artifactName);
        try {
            worker.scan(run, launcher);
        }
        catch (Exception ex) {
            this.archiveAndAddAction(run, workspace, launcher, listener, artifactName, reportNumber);
            throw new AbortException(ex.getMessage());
        }
        this.archiveAndAddAction(run, workspace, launcher, listener, artifactName, reportNumber);
    }

    private String getBuildUser(String url) throws IOException {
        StringBuilder result = new StringBuilder();
        URL urlVar = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)urlVar.openConnection();
        conn.setRequestMethod("GET");
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        String userName = "";
        try {
            JSONObject json = JSONObject.fromObject((Object)result.toString());
            JSONObject action = (JSONObject)json.getJSONArray("actions").get(0);
            JSONObject cause = (JSONObject)action.getJSONArray("causes").get(0);
            userName = cause.getString("userName");
        }
        catch (JSONException e) {
            userName = "anonymous";
        }
        return userName;
    }

    private Config printInfoFromUser(Run<?, ?> run, TaskListener listener) throws AbortException, URISyntaxException {
        EnvVars env;
        DescriptorImpl globalConfig = this.getDescriptor();
        String controllerApiUrl = "";
        if (globalConfig.getControllerApiUrl() != null) {
            controllerApiUrl = globalConfig.getControllerApiUrl().trim();
        }
        String user = "";
        if (globalConfig.getUser() != null) {
            user = globalConfig.getUser().trim();
        }
        String password = "";
        if (globalConfig.getPassword() != null) {
            password = Secret.toString((Secret)globalConfig.getPassword()).trim();
        }
        boolean disableTLSCertVerification = globalConfig.getDisableTLSCertVerification();
        String serverCertificate = globalConfig.getServerCertificate();
        int timeout = globalConfig.getTimeout();
        List<Registry> registries = globalConfig.getRegistries();
        if (this.repository == null || this.registrySelection == null) {
            throw new AbortException("repository and registrySelection both are required.");
        }
        try {
            env = run.getEnvironment(listener);
        }
        catch (IOException | InterruptedException e) {
            throw new AbortException("Error when getting Jenkins project environment.");
        }
        String currentRepository = env.expand(this.repository.trim());
        String currentTag = env.expand(this.tag);
        String buildUrl = (String)env.get((Object)"BUILD_URL") + "api/json";
        String buildUser = "";
        try {
            buildUser = this.getBuildUser(buildUrl);
        }
        catch (IOException e) {
            this.logger.println("Build user not found.");
        }
        this.logger.println("");
        this.logger.println("*************************************************************");
        ScanMeta scanMeta = new ScanMeta();
        scanMeta.setSource(globalConfig.getSource());
        scanMeta.setUser(buildUser);
        scanMeta.setJob((String)env.get((Object)"JOB_NAME"));
        scanMeta.setWorkspace((String)env.get((Object)"WORKSPACE"));
        if (scanMeta.getSource() == null || scanMeta.getSource().isEmpty()) {
            this.logger.println("Scanner Source Name: (Please set a name in Jenkins -> Configure System -> NeuVector Vulnerablity Scanner -> NeuVector Scanner Source Name )");
        } else {
            this.logger.println("Scanner Source Name: " + scanMeta.getSource());
        }
        this.logger.println("Build User: " + scanMeta.getUser());
        this.logger.println("Job Name: " + scanMeta.getJob());
        this.logger.println("Workspace: " + scanMeta.getWorkspace());
        boolean isLocal = true;
        Registry selectRegistry = null;
        if (Strings.isNullOrEmpty((String)this.registrySelection) || this.registrySelection.equalsIgnoreCase(REGISTRY_DROPDOWN_DEFAULT)) {
            throw new AbortException("Please select a registry or choose Local.");
        }
        if (this.registrySelection.equalsIgnoreCase("Local")) {
            this.logger.println("Local case.");
        } else {
            if (registries == null) {
                throw new AbortException("Registry " + this.registrySelection + " in current project is missing or deleted in global configuration.");
            }
            boolean found = false;
            for (Registry registry : registries) {
                if (registry.getNickname().isEmpty() || registry.getRegUrl().isEmpty()) {
                    throw new AbortException("Registry nickname and URL cannot be empty");
                }
                if (!registry.getNickname().equalsIgnoreCase(this.registrySelection)) continue;
                found = true;
                isLocal = false;
                selectRegistry = registry;
                this.logger.println("Registry: " + this.registrySelection);
                this.logger.println("Registry URL: " + selectRegistry.getRegUrl());
                this.logger.println("Registry Username: " + selectRegistry.getRegUsername());
                break;
            }
            if (!found) {
                throw new AbortException("Registry " + this.registrySelection + " in current project is missing or deleted in global configuration.");
            }
        }
        this.logger.println("Repository: " + currentRepository);
        this.logger.println("Tag: " + currentTag);
        Double highSeverityThreshold = globalConfig.highSeverityThreshold;
        Double mediumSeverityThreshold = globalConfig.mediumSeverityThreshold;
        boolean customizedRatingScale = false;
        if (highSeverityThreshold != null && mediumSeverityThreshold != null) {
            customizedRatingScale = true;
        }
        return new Config.ConfigBuilder(controllerApiUrl, user, password, disableTLSCertVerification, serverCertificate).standaloneScanner(this.standaloneScanner).scanMeta(scanMeta).timeout(timeout).isLocal(isLocal).scannerRegistryURL(globalConfig.scannerRegistryURL).scannerRegistryUser(globalConfig.scannerRegistryUser).scannerRegistryPassword(globalConfig.scannerRegistryPassword).scannerImage(globalConfig.scannerImage).registry(selectRegistry).repository(currentRepository).tag(currentTag).scanLayers(this.scanLayers).scanTimeout(this.scanTimeout).highSeverityThreshold(highSeverityThreshold).mediumSeverityThreshold(mediumSeverityThreshold).customizedRatingScale(customizedRatingScale).numberOfHighSeverityToFail(this.numberOfHighSeverityToFail).numberOfMediumSeverityToFail(this.numberOfMediumSeverityToFail).nameOfVulnerabilityToFailOne(this.nameOfVulnerabilityToFailOne).nameOfVulnerabilityToFailTwo(this.nameOfVulnerabilityToFailTwo).nameOfVulnerabilityToFailThree(this.nameOfVulnerabilityToFailThree).nameOfVulnerabilityToFailFour(this.nameOfVulnerabilityToFailFour).nameOfVulnerabilityToExemptOne(this.nameOfVulnerabilityToExemptOne).nameOfVulnerabilityToExemptTwo(this.nameOfVulnerabilityToExemptTwo).nameOfVulnerabilityToExemptThree(this.nameOfVulnerabilityToExemptThree).nameOfVulnerabilityToExemptFour(this.nameOfVulnerabilityToExemptFour).build();
    }

    private void archiveAndAddAction(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener, String artifactName, String reportNumber) {
        ArtifactArchiver artifactArchiver;
        try {
            ArtifactArchiver artifactArchiver2 = new ArtifactArchiver(artifactName);
            artifactArchiver2.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            this.logger.println("Failed to archive the artifact file: " + artifactName);
        }
        String artifactNameHTML = artifactName + ".html";
        try {
            artifactArchiver = new ArtifactArchiver(artifactNameHTML);
            artifactArchiver.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            this.logger.println("Failed to archive the artifact HTML: " + artifactNameHTML);
        }
        try {
            artifactArchiver = new ArtifactArchiver("styles.css");
            artifactArchiver.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            this.logger.println("Failed to archive the artifact css style file. ");
        }
        run.addAction((Action)new NeuVectorAction(run, artifactNameHTML, reportNumber));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    static {
        buildHash = 0;
    }

    @Symbol(value={"neuvector"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String source;
        private String controllerIP;
        private String controllerPort;
        private String controllerApiUrl;
        private String user;
        private Secret password;
        private int timeout;
        private String scannerRegistryURL;
        private String scannerImage;
        private boolean disableTLSCertVerification;
        private String serverCertificate;
        private String scannerRegistryUser;
        private Secret scannerRegistryPassword;
        private Double mediumSeverityThreshold;
        private Double highSeverityThreshold;
        private List<Registry> registries;

        public void setSource(String source) {
            this.source = source;
        }

        public void setScannerRegistryURL(String scannerRegistryURL) {
            this.scannerRegistryURL = scannerRegistryURL;
        }

        public void setScannerImage(String scannerImage) {
            this.scannerImage = scannerImage;
        }

        public void setDisableTLSCertVerification(Boolean disableTLSCertVerification) {
            this.disableTLSCertVerification = disableTLSCertVerification;
        }

        public void setServerCertificate(String serverCertificate) {
            this.serverCertificate = serverCertificate;
        }

        public void setScannerRegistryUser(String scannerRegistryUser) {
            this.scannerRegistryUser = scannerRegistryUser;
        }

        public void setScannerRegistryPassword(Secret scannerRegistryPassword) {
            this.scannerRegistryPassword = scannerRegistryPassword;
        }

        public void setControllerIP(String controllerIP) {
            this.controllerIP = controllerIP;
        }

        public void setControllerPort(String controllerPort) {
            this.controllerPort = controllerPort;
        }

        public void setControllerApiUrl(String controllerApiUrl) {
            this.controllerApiUrl = controllerApiUrl;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(Secret password) {
            this.password = password;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void setRegistries(List<Registry> registries) {
            this.registries = registries;
        }

        public void setMediumSeverityThreshold(Double mediumSeverityThreshold) {
            this.mediumSeverityThreshold = mediumSeverityThreshold;
        }

        public void setHighSeverityThreshold(Double highSeverityThreshold) {
            this.highSeverityThreshold = highSeverityThreshold;
        }

        public Double getMediumSeverityThreshold() {
            return this.mediumSeverityThreshold;
        }

        public Double getHighSeverityThreshold() {
            return this.highSeverityThreshold;
        }

        public String getSource() {
            return this.source;
        }

        public String getControllerApiUrl() {
            return this.controllerApiUrl;
        }

        public String getUser() {
            return this.user;
        }

        public Secret getPassword() {
            return this.password;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public String getScannerRegistryURL() {
            return this.scannerRegistryURL;
        }

        public String getScannerImage() {
            return this.scannerImage;
        }

        public Boolean getDisableTLSCertVerification() {
            return this.disableTLSCertVerification;
        }

        public String getServerCertificate() {
            return this.serverCertificate;
        }

        public String getScannerRegistryUser() {
            return this.scannerRegistryUser;
        }

        public Secret getScannerRegistryPassword() {
            return this.scannerRegistryPassword;
        }

        public List<Registry> getRegistries() {
            return this.registries;
        }

        public DescriptorImpl() {
            this.load();
        }

        public ListBoxModel doFillRegistrySelectionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(NeuVectorBuilder.REGISTRY_DROPDOWN_DEFAULT);
            items.add("Local");
            if (this.registries != null) {
                for (Registry reg : this.registries) {
                    items.add(reg.getNickname());
                }
            }
            return items;
        }

        public FormValidation doCheckScanTimeout(@QueryParameter(value="scanTimeout") Integer scanTimeout) {
            if (scanTimeout > 0 && scanTimeout <= 60) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_scanTimeout());
        }

        public FormValidation doCheckRegistrySelection(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.equalsIgnoreCase(NeuVectorBuilder.REGISTRY_DROPDOWN_DEFAULT)) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_registrySelection());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckControllerApiUrl(@QueryParameter String value) {
            if (value != null && !value.trim().isEmpty() && !value.trim().matches("^https://([a-zA-Z0-9.-]+)(:([0-9]+))?(/[a-zA-Z0-9./-]+)?$")) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_controllerApiUrl());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            try {
                if (Integer.parseInt(value) < 0) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_timeout());
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_timeout());
            }
        }

        public FormValidation doCheckMediumSeverityThreshold(@QueryParameter Double value, @QueryParameter Double highSeverityThreshold) {
            if (value != null) {
                if (value < 0.0 || value > 10.0) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_invalidScore());
                }
                if (highSeverityThreshold == null) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_missingSeverityScore());
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHighSeverityThreshold(@QueryParameter Double value, @QueryParameter Double mediumSeverityThreshold) {
            if (value != null) {
                if (value < 0.0 || value > 10.0) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_invalidScore());
                }
                if (mediumSeverityThreshold == null) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_missingSeverityScore());
                }
                if (value <= mediumSeverityThreshold) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_invalidThreshold());
                }
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doTestConnection(@QueryParameter(value="controllerApiUrl") String controllerApiUrl, @QueryParameter(value="user") String user, @QueryParameter(value="password") Secret password, @QueryParameter(value="disableTLSCertVerification") boolean disableTLSCertVerification, @QueryParameter(value="serverCertificate") String serverCertificate) throws URISyntaxException {
            Jenkins.getInstance().checkPermission(Jenkins.ADMINISTER);
            Config config = new Config.ConfigBuilder(controllerApiUrl, user, Secret.toString((Secret)password).trim(), disableTLSCertVerification, serverCertificate).build();
            NeuVectorWorker worker = new NeuVectorWorker(null, config);
            try {
                worker.testConnection();
                return FormValidation.ok((String)"Connection Success");
            }
            catch (Exception e) {
                return FormValidation.error((String)("Failed to connect " + config.getControllerApiUrl().toString() + ". " + e.getMessage()));
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.NeuVectorBuilder_DescriptorImpl_DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            block3: {
                try {
                    JSONObject registriesJsonObj = formData.getJSONObject("registries");
                    if (registriesJsonObj == null || registriesJsonObj.isEmpty()) {
                        this.registries = null;
                    }
                }
                catch (JSONException e) {
                    JSONArray registriesJsonArray = formData.getJSONArray("registries");
                    if (registriesJsonArray != null && !registriesJsonArray.isEmpty()) break block3;
                    this.registries = null;
                }
            }
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }

        protected Object readResolve() {
            boolean migrated;
            boolean bl = migrated = this.serverCertificate == null;
            if (migrated) {
                boolean bl2 = this.disableTLSCertVerification = this.user != null && !this.user.isEmpty();
            }
            if (!(this.controllerApiUrl != null && !this.controllerApiUrl.isEmpty() || this.controllerIP == null || this.controllerIP.isEmpty() || this.controllerPort == null || this.controllerPort.isEmpty())) {
                this.controllerApiUrl = "https://" + this.controllerIP.trim() + ":" + this.controllerPort.trim();
            }
            return this;
        }
    }
}

