/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector;

import io.jenkins.plugins.neuvector.Registry;
import io.jenkins.plugins.neuvector.model.ScanMeta;

public class Config {
    private ScanMeta scanMeta;
    private String controllerIP;
    private int controllerPort;
    private String user;
    private String password;
    private int timeout;
    private boolean isLocal;
    private Registry registry;
    private String repository;
    private String tag;
    private boolean scanLayers;
    private String numberOfHighSeverityToFail;
    private String numberOfMediumSeverityToFail;
    private String nameOfVulnerabilityToFailOne;
    private String nameOfVulnerabilityToFailTwo;
    private String nameOfVulnerabilityToFailThree;
    private String nameOfVulnerabilityToFailFour;

    private Config(ConfigBuilder builder) {
        this.scanMeta = builder.scanMeta;
        this.controllerIP = builder.controllerIP;
        this.controllerPort = builder.controllerPort;
        this.user = builder.user;
        this.password = builder.password;
        this.timeout = builder.timeout;
        this.isLocal = builder.isLocal;
        this.registry = builder.registry;
        this.repository = builder.repository;
        this.tag = builder.tag;
        this.scanLayers = builder.scanLayers;
        this.numberOfHighSeverityToFail = builder.numberOfHighSeverityToFail;
        this.numberOfMediumSeverityToFail = builder.numberOfMediumSeverityToFail;
        this.nameOfVulnerabilityToFailOne = builder.nameOfVulnerabilityToFailOne;
        this.nameOfVulnerabilityToFailTwo = builder.nameOfVulnerabilityToFailTwo;
        this.nameOfVulnerabilityToFailThree = builder.nameOfVulnerabilityToFailThree;
        this.nameOfVulnerabilityToFailFour = builder.nameOfVulnerabilityToFailFour;
    }

    public ScanMeta getScanMeta() {
        return this.scanMeta;
    }

    public String getControllerIP() {
        return this.controllerIP;
    }

    public int getControllerPort() {
        return this.controllerPort;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean getScanLayers() {
        return this.scanLayers;
    }

    public String getNumberOfHighSeverityToFail() {
        return this.numberOfHighSeverityToFail;
    }

    public String getNumberOfMediumSeverityToFail() {
        return this.numberOfMediumSeverityToFail;
    }

    public String getNameOfVulnerabilityToFailOne() {
        return this.nameOfVulnerabilityToFailOne;
    }

    public String getNameOfVulnerabilityToFailTwo() {
        return this.nameOfVulnerabilityToFailTwo;
    }

    public String getNameOfVulnerabilityToFailThree() {
        return this.nameOfVulnerabilityToFailThree;
    }

    public String getNameOfVulnerabilityToFailFour() {
        return this.nameOfVulnerabilityToFailFour;
    }

    public static class ConfigBuilder {
        private ScanMeta scanMeta;
        private final String controllerIP;
        private final int controllerPort;
        private final String user;
        private final String password;
        private int timeout;
        private boolean isLocal;
        private Registry registry;
        private String repository;
        private String tag;
        private boolean scanLayers;
        private String numberOfHighSeverityToFail;
        private String numberOfMediumSeverityToFail;
        private String nameOfVulnerabilityToFailOne;
        private String nameOfVulnerabilityToFailTwo;
        private String nameOfVulnerabilityToFailThree;
        private String nameOfVulnerabilityToFailFour;

        public ConfigBuilder(String controllerIP, int controllerPort, String user, String password) {
            this.controllerIP = controllerIP;
            this.controllerPort = controllerPort;
            this.user = user;
            this.password = password;
        }

        public Config build() {
            Config config = new Config(this);
            return config;
        }

        public ConfigBuilder scanMeta(ScanMeta scanMeta) {
            this.scanMeta = scanMeta;
            return this;
        }

        public ConfigBuilder timeout(int timeout) {
            this.timeout = timeout;
            return this;
        }

        public ConfigBuilder isLocal(boolean isLocal) {
            this.isLocal = isLocal;
            return this;
        }

        public ConfigBuilder registry(Registry registry) {
            this.registry = registry;
            return this;
        }

        public ConfigBuilder repository(String repository) {
            this.repository = repository;
            return this;
        }

        public ConfigBuilder tag(String tag) {
            this.tag = tag;
            return this;
        }

        public ConfigBuilder scanLayers(boolean scanLayers) {
            this.scanLayers = scanLayers;
            return this;
        }

        public ConfigBuilder numberOfHighSeverityToFail(String numberOfHighSeverityToFail) {
            this.numberOfHighSeverityToFail = numberOfHighSeverityToFail;
            return this;
        }

        public ConfigBuilder numberOfMediumSeverityToFail(String numberOfMediumSeverityToFail) {
            this.numberOfMediumSeverityToFail = numberOfMediumSeverityToFail;
            return this;
        }

        public ConfigBuilder nameOfVulnerabilityToFailOne(String nameOfVulnerabilityToFailOne) {
            this.nameOfVulnerabilityToFailOne = nameOfVulnerabilityToFailOne;
            return this;
        }

        public ConfigBuilder nameOfVulnerabilityToFailTwo(String nameOfVulnerabilityToFailTwo) {
            this.nameOfVulnerabilityToFailTwo = nameOfVulnerabilityToFailTwo;
            return this;
        }

        public ConfigBuilder nameOfVulnerabilityToFailThree(String nameOfVulnerabilityToFailThree) {
            this.nameOfVulnerabilityToFailThree = nameOfVulnerabilityToFailThree;
            return this;
        }

        public ConfigBuilder nameOfVulnerabilityToFailFour(String nameOfVulnerabilityToFailFour) {
            this.nameOfVulnerabilityToFailFour = nameOfVulnerabilityToFailFour;
            return this;
        }
    }
}

