/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.neuvector;

import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.neuvector.Config;
import io.jenkins.plugins.neuvector.Log;
import io.jenkins.plugins.neuvector.Messages;
import io.jenkins.plugins.neuvector.NeuVectorAction;
import io.jenkins.plugins.neuvector.NeuVectorWorker;
import io.jenkins.plugins.neuvector.Registry;
import io.jenkins.plugins.neuvector.model.ScanMeta;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class NeuVectorBuilder
extends Builder
implements SimpleBuildStep {
    private static final String REGISTRY_DROPDOWN_DEFAULT = "Please select a registry:";
    private boolean standaloneScanner;
    private final String repository;
    private String tag;
    private boolean scanLayers;
    private String numberOfHighSeverityToFail;
    private String numberOfMediumSeverityToFail;
    private String nameOfVulnerabilityToFailOne;
    private String nameOfVulnerabilityToFailTwo;
    private String nameOfVulnerabilityToFailThree;
    private String nameOfVulnerabilityToFailFour;
    private String nameOfVulnerabilityToExemptOne;
    private String nameOfVulnerabilityToExemptTwo;
    private String nameOfVulnerabilityToExemptThree;
    private String nameOfVulnerabilityToExemptFour;
    private final String registrySelection;
    private static int buildStep;
    private static int buildHash;
    private Log logger;

    public static synchronized void setBuildStep(int buildStep) {
        NeuVectorBuilder.buildStep = buildStep;
    }

    public static synchronized void setBuildHash(int buildHash) {
        NeuVectorBuilder.buildHash = buildHash;
    }

    @DataBoundConstructor
    public NeuVectorBuilder(String repository, String registrySelection) {
        this.repository = repository;
        this.registrySelection = registrySelection;
    }

    public boolean getStandaloneScanner() {
        return this.standaloneScanner;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean getScanLayers() {
        return this.scanLayers;
    }

    public String getNumberOfHighSeverityToFail() {
        return this.numberOfHighSeverityToFail;
    }

    public String getNumberOfMediumSeverityToFail() {
        return this.numberOfMediumSeverityToFail;
    }

    public String getNameOfVulnerabilityToFailOne() {
        return this.nameOfVulnerabilityToFailOne;
    }

    public String getNameOfVulnerabilityToFailTwo() {
        return this.nameOfVulnerabilityToFailTwo;
    }

    public String getNameOfVulnerabilityToFailThree() {
        return this.nameOfVulnerabilityToFailThree;
    }

    public String getNameOfVulnerabilityToFailFour() {
        return this.nameOfVulnerabilityToFailFour;
    }

    public String getNameOfVulnerabilityToExemptOne() {
        return this.nameOfVulnerabilityToExemptOne;
    }

    public String getNameOfVulnerabilityToExemptTwo() {
        return this.nameOfVulnerabilityToExemptTwo;
    }

    public String getNameOfVulnerabilityToExemptThree() {
        return this.nameOfVulnerabilityToExemptThree;
    }

    public String getNameOfVulnerabilityToExemptFour() {
        return this.nameOfVulnerabilityToExemptFour;
    }

    public String getRegistrySelection() {
        return this.registrySelection;
    }

    @DataBoundSetter
    public void setStandaloneScanner(boolean standaloneScanner) {
        this.standaloneScanner = standaloneScanner;
    }

    @DataBoundSetter
    public void setTag(String tag) {
        this.tag = tag.trim();
    }

    @DataBoundSetter
    public void setScanLayers(boolean scanLayers) {
        this.scanLayers = scanLayers;
    }

    @DataBoundSetter
    public void setNumberOfHighSeverityToFail(String numberOfHighSeverityToFail) {
        this.numberOfHighSeverityToFail = numberOfHighSeverityToFail.trim();
    }

    @DataBoundSetter
    public void setNumberOfMediumSeverityToFail(String numberOfMediumSeverityToFail) {
        this.numberOfMediumSeverityToFail = numberOfMediumSeverityToFail.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailOne(String nameOfVulnerabilityToFailOne) {
        this.nameOfVulnerabilityToFailOne = nameOfVulnerabilityToFailOne.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailTwo(String nameOfVulnerabilityToFailTwo) {
        this.nameOfVulnerabilityToFailTwo = nameOfVulnerabilityToFailTwo.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailThree(String nameOfVulnerabilityToFailThree) {
        this.nameOfVulnerabilityToFailThree = nameOfVulnerabilityToFailThree.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToFailFour(String nameOfVulnerabilityToFailFour) {
        this.nameOfVulnerabilityToFailFour = nameOfVulnerabilityToFailFour.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToExemptOne(String nameOfVulnerabilityToExemptOne) {
        this.nameOfVulnerabilityToExemptOne = nameOfVulnerabilityToExemptOne.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToExemptTwo(String nameOfVulnerabilityToExemptTwo) {
        this.nameOfVulnerabilityToExemptTwo = nameOfVulnerabilityToExemptTwo.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToExemptThree(String nameOfVulnerabilityToExemptThree) {
        this.nameOfVulnerabilityToExemptThree = nameOfVulnerabilityToExemptThree.trim();
    }

    @DataBoundSetter
    public void setNameOfVulnerabilityToExemptFour(String nameOfVulnerabilityToExemptFour) {
        this.nameOfVulnerabilityToExemptFour = nameOfVulnerabilityToExemptFour.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        this.logger = new Log(listener.getLogger());
        System.setProperty("hudson.model.DirectoryBrowserSupport.CSP", "default-src 'self'; style-src 'self' 'unsafe-inline';");
        EnvVars env = run.getEnvironment(listener);
        FilePath targetCss = new FilePath(workspace, "styles.css");
        File cssFile = new File((String)env.get((Object)"JENKINS_HOME") + "/plugins/neuvector-vulnerability-scanner/css/", "styles.css");
        FilePath cssFilePath = new FilePath(cssFile);
        cssFilePath.copyTo(targetCss);
        String artifactName = "NeuVectorReport_" + run.getParent().getDisplayName() + "_" + run.getNumber();
        if (run.hashCode() != buildHash) {
            NeuVectorBuilder.setBuildHash(run.hashCode());
            NeuVectorBuilder.setBuildStep(1);
        } else {
            NeuVectorBuilder.setBuildStep(buildStep + 1);
        }
        String reportNumber = Integer.toString(buildStep);
        artifactName = artifactName + "-" + reportNumber;
        Config config = this.printInfoFromUser(run, listener);
        NeuVectorWorker worker = new NeuVectorWorker(this.logger, config, workspace, artifactName);
        try {
            worker.scan(run, launcher);
        }
        finally {
            this.archiveAndAddAction(run, workspace, launcher, listener, artifactName, reportNumber);
        }
    }

    private String getBuildUser(String url) throws IOException {
        StringBuilder result = new StringBuilder();
        URL urlVar = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)urlVar.openConnection();
        conn.setRequestMethod("GET");
        try (BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
            String line;
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        String userName = "";
        try {
            JSONObject json = JSONObject.fromObject((Object)result.toString());
            JSONObject action = (JSONObject)json.getJSONArray("actions").get(0);
            JSONObject cause = (JSONObject)action.getJSONArray("causes").get(0);
            userName = cause.getString("userName");
        }
        catch (JSONException e) {
            userName = "anonymous";
        }
        return userName;
    }

    private Config printInfoFromUser(Run<?, ?> run, TaskListener listener) throws AbortException {
        EnvVars env;
        DescriptorImpl globalConfig = this.getDescriptor();
        String controllerIP = globalConfig.getControllerIP().trim();
        int controllerPort = Integer.parseInt(globalConfig.getControllerPort().trim());
        String user = globalConfig.getUser().trim();
        String password = Secret.toString((Secret)globalConfig.getPassword()).trim();
        int timeout = globalConfig.getTimeout();
        List<Registry> registries = globalConfig.getRegistries();
        if (controllerIP.isEmpty() || user.isEmpty() || password.isEmpty()) {
            throw new AbortException("Missing global configuration for NeuVector.");
        }
        if (this.repository == null || this.registrySelection == null) {
            throw new AbortException("repository and registrySelection both are required.");
        }
        try {
            env = run.getEnvironment(listener);
        }
        catch (IOException | InterruptedException e) {
            throw new AbortException("Error when getting Jenkins project environment.");
        }
        String currentRepository = env.expand(this.repository.trim());
        String currentTag = env.expand(this.tag);
        String buildUrl = (String)env.get((Object)"BUILD_URL") + "api/json";
        String buildUser = "";
        try {
            buildUser = this.getBuildUser(buildUrl);
        }
        catch (IOException e) {
            this.logger.println("Build user not found.");
        }
        this.logger.println("");
        this.logger.println("*************************************************************");
        ScanMeta scanMeta = new ScanMeta();
        scanMeta.setSource(globalConfig.getSource());
        scanMeta.setUser(buildUser);
        scanMeta.setJob((String)env.get((Object)"JOB_NAME"));
        scanMeta.setWorkspace((String)env.get((Object)"WORKSPACE"));
        if (scanMeta.getSource() == null || scanMeta.getSource().isEmpty()) {
            this.logger.println("Scanner Source Name: (Please set a name in Jenkins -> Configure System -> NeuVector Vulnerablity Scanner -> NeuVector Scanner Source Name )");
        } else {
            this.logger.println("Scanner Source Name: " + scanMeta.getSource());
        }
        this.logger.println("Build User: " + scanMeta.getUser());
        this.logger.println("Job Name: " + scanMeta.getJob());
        this.logger.println("Workspace: " + scanMeta.getWorkspace());
        boolean isLocal = true;
        Registry selectRegistry = null;
        if (Strings.isNullOrEmpty((String)this.registrySelection) || this.registrySelection.equalsIgnoreCase(REGISTRY_DROPDOWN_DEFAULT)) {
            throw new AbortException("Please select a registry or choose Local.");
        }
        if (this.registrySelection.equalsIgnoreCase("Local")) {
            this.logger.println("Local case.");
        } else {
            if (registries == null) {
                throw new AbortException("Registry " + this.registrySelection + " in current project is missing or deleted in global configuration.");
            }
            boolean found = false;
            for (Registry registry : registries) {
                if (registry.getNickname().isEmpty() || registry.getRegUrl().isEmpty()) {
                    throw new AbortException("Registry nickname and URL cannot be empty");
                }
                if (!registry.getNickname().equalsIgnoreCase(this.registrySelection)) continue;
                found = true;
                isLocal = false;
                selectRegistry = registry;
                this.logger.println("Registry: " + this.registrySelection);
                this.logger.println("Registry URL: " + selectRegistry.getRegUrl());
                this.logger.println("Registry Username: " + selectRegistry.getRegUsername());
                break;
            }
            if (!found) {
                throw new AbortException("Registry " + this.registrySelection + " in current project is missing or deleted in global configuration.");
            }
        }
        this.logger.println("Repository: " + currentRepository);
        this.logger.println("Tag: " + currentTag);
        Double highSeverityThreshold = globalConfig.highSeverityThreshold;
        Double mediumSeverityThreshold = globalConfig.mediumSeverityThreshold;
        boolean customizedRatingScale = false;
        if (highSeverityThreshold != null && mediumSeverityThreshold != null) {
            customizedRatingScale = true;
        }
        return new Config.ConfigBuilder(controllerIP, controllerPort, user, password).standaloneScanner(this.standaloneScanner).scanMeta(scanMeta).timeout(timeout).isLocal(isLocal).scannerRegistryURL(globalConfig.scannerRegistryURL).scannerRegistryUser(globalConfig.scannerRegistryUser).scannerRegistryPassword(globalConfig.scannerRegistryPassword).scannerImage(globalConfig.scannerImage).license(globalConfig.license).registry(selectRegistry).repository(currentRepository).tag(currentTag).scanLayers(this.scanLayers).highSeverityThreshold(highSeverityThreshold).mediumSeverityThreshold(mediumSeverityThreshold).customizedRatingScale(customizedRatingScale).numberOfHighSeverityToFail(this.numberOfHighSeverityToFail).numberOfMediumSeverityToFail(this.numberOfMediumSeverityToFail).nameOfVulnerabilityToFailOne(this.nameOfVulnerabilityToFailOne).nameOfVulnerabilityToFailTwo(this.nameOfVulnerabilityToFailTwo).nameOfVulnerabilityToFailThree(this.nameOfVulnerabilityToFailThree).nameOfVulnerabilityToFailFour(this.nameOfVulnerabilityToFailFour).nameOfVulnerabilityToExemptOne(this.nameOfVulnerabilityToExemptOne).nameOfVulnerabilityToExemptTwo(this.nameOfVulnerabilityToExemptTwo).nameOfVulnerabilityToExemptThree(this.nameOfVulnerabilityToExemptThree).nameOfVulnerabilityToExemptFour(this.nameOfVulnerabilityToExemptFour).build();
    }

    private void archiveAndAddAction(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener, String artifactName, String reportNumber) throws InterruptedException, IOException {
        ArtifactArchiver artifactArchiver;
        try {
            ArtifactArchiver artifactArchiver2 = new ArtifactArchiver(artifactName);
            artifactArchiver2.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            throw new InterruptedException("Failed to export the scan result because of an unexpected error.");
        }
        String artifactNameHTML = artifactName + ".html";
        try {
            artifactArchiver = new ArtifactArchiver(artifactNameHTML);
            artifactArchiver.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            throw new InterruptedException("Failed to export the scan result because of an unexpected error.");
        }
        try {
            artifactArchiver = new ArtifactArchiver("styles.css");
            artifactArchiver.perform(run, workspace, launcher, listener);
        }
        catch (Exception e) {
            throw new InterruptedException("Failed to export the scan result because of an unexpected error.");
        }
        run.addAction((Action)new NeuVectorAction(run, artifactNameHTML, reportNumber));
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    static {
        buildHash = 0;
    }

    @Symbol(value={"neuvector"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private String source;
        private String controllerIP;
        private String controllerPort;
        private String user;
        private Secret password;
        private int timeout;
        private String scannerRegistryURL;
        private String scannerImage;
        private String scannerRegistryUser;
        private Secret scannerRegistryPassword;
        private String license;
        private Double mediumSeverityThreshold;
        private Double highSeverityThreshold;
        private List<Registry> registries;

        public void setSource(String source) {
            this.source = source;
        }

        public void setScannerRegistryURL(String scannerRegistryURL) {
            this.scannerRegistryURL = scannerRegistryURL;
        }

        public void setScannerImage(String scannerImage) {
            this.scannerImage = scannerImage;
        }

        public void setScannerRegistryUser(String scannerRegistryUser) {
            this.scannerRegistryUser = scannerRegistryUser;
        }

        public void setScannerRegistryPassword(Secret scannerRegistryPassword) {
            this.scannerRegistryPassword = scannerRegistryPassword;
        }

        public void setLicense(String license) {
            this.license = license;
        }

        public void setControllerIP(String controllerIP) {
            this.controllerIP = controllerIP;
        }

        public void setControllerPort(String controllerPort) {
            this.controllerPort = controllerPort;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(Secret password) {
            this.password = password;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        public void setRegistries(List<Registry> registries) {
            this.registries = registries;
        }

        public void setMediumSeverityThreshold(Double mediumSeverityThreshold) {
            this.mediumSeverityThreshold = mediumSeverityThreshold;
        }

        public void setHighSeverityThreshold(Double highSeverityThreshold) {
            this.highSeverityThreshold = highSeverityThreshold;
        }

        public Double getMediumSeverityThreshold() {
            return this.mediumSeverityThreshold;
        }

        public Double getHighSeverityThreshold() {
            return this.highSeverityThreshold;
        }

        public String getSource() {
            return this.source;
        }

        public String getControllerIP() {
            return this.controllerIP;
        }

        public String getControllerPort() {
            return this.controllerPort;
        }

        public String getUser() {
            return this.user;
        }

        public Secret getPassword() {
            return this.password;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public String getScannerRegistryURL() {
            return this.scannerRegistryURL;
        }

        public String getScannerImage() {
            return this.scannerImage;
        }

        public String getScannerRegistryUser() {
            return this.scannerRegistryUser;
        }

        public Secret getScannerRegistryPassword() {
            return this.scannerRegistryPassword;
        }

        public String getLicense() {
            return this.license;
        }

        public List<Registry> getRegistries() {
            return this.registries;
        }

        public DescriptorImpl() {
            this.load();
        }

        public ListBoxModel doFillRegistrySelectionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add(NeuVectorBuilder.REGISTRY_DROPDOWN_DEFAULT);
            items.add("Local");
            if (this.registries != null) {
                for (Registry reg : this.registries) {
                    items.add(reg.getNickname());
                }
            }
            return items;
        }

        public FormValidation doCheckRegistrySelection(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.equalsIgnoreCase(NeuVectorBuilder.REGISTRY_DROPDOWN_DEFAULT)) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_registrySelection());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckControllerIP(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.trim().isEmpty() || value.trim().matches("^(http|https)://.*$")) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_controllerIP());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckControllerPort(@QueryParameter String value) {
            try {
                if (Integer.parseInt(value.trim()) < 0) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_controllerPort());
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_controllerPort());
            }
        }

        public FormValidation doCheckUser(@QueryParameter String value) {
            if (Strings.isNullOrEmpty((String)value) || value.trim().isEmpty()) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_user());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckPassword(@QueryParameter Secret value) {
            if (Secret.toString((Secret)value).trim().isEmpty()) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_password());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTimeout(@QueryParameter String value) {
            try {
                if (Integer.parseInt(value) < 0) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_timeout());
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_timeout());
            }
        }

        public FormValidation doCheckMediumSeverityThreshold(@QueryParameter Double value, @QueryParameter Double highSeverityThreshold) {
            if (value != null) {
                if (value < 0.0 || value > 10.0) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_invalidScore());
                }
                if (highSeverityThreshold == null) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_missingSeverityScore());
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHighSeverityThreshold(@QueryParameter Double value, @QueryParameter Double mediumSeverityThreshold) {
            if (value != null) {
                if (value < 0.0 || value > 10.0) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_invalidScore());
                }
                if (mediumSeverityThreshold == null) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_missingSeverityScore());
                }
                if (value <= mediumSeverityThreshold) {
                    return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_invalidThreshold());
                }
            }
            return FormValidation.ok();
        }

        public FormValidation doTestConnection(@QueryParameter(value="controllerIP") String controllerIP, @QueryParameter(value="controllerPort") String controllerPort, @QueryParameter(value="user") String user, @QueryParameter(value="password") Secret password) {
            int port;
            try {
                port = Integer.parseInt(controllerPort.trim());
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)Messages.NeuVectorBuilder_DescriptorImpl_errors_controllerPort());
            }
            Config config = new Config.ConfigBuilder(controllerIP, port, user, Secret.toString((Secret)password).trim()).build();
            NeuVectorWorker worker = new NeuVectorWorker(null, config);
            try {
                worker.testConnection();
                return FormValidation.ok((String)"Connection Success");
            }
            catch (IOException e) {
                return FormValidation.error((String)("Connection error: " + e.getMessage()));
            }
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.NeuVectorBuilder_DescriptorImpl_DisplayName();
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            block3: {
                try {
                    JSONObject registriesJsonObj = formData.getJSONObject("registries");
                    if (registriesJsonObj == null || registriesJsonObj.isEmpty()) {
                        this.registries = null;
                    }
                }
                catch (JSONException e) {
                    JSONArray registriesJsonArray = formData.getJSONArray("registries");
                    if (registriesJsonArray != null && !registriesJsonArray.isEmpty()) break block3;
                    this.registries = null;
                }
            }
            req.bindJSON((Object)this, formData);
            this.save();
            return true;
        }
    }
}

