/*
 * Decompiled with CFR 0.152.
 */
package de.westemeyer.plugins.multiselect.parser;

import de.westemeyer.plugins.multiselect.MultiselectDecisionItem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ValueConstructionHelper {
    private static final String DELIMITER = ", ";
    private final Map<String, ValueConstructionHelper> lookup = new LinkedHashMap<String, ValueConstructionHelper>();
    private final MultiselectDecisionItem decisionItem;

    ValueConstructionHelper(MultiselectDecisionItem decisionItem) {
        this.decisionItem = decisionItem;
    }

    ValueConstructionHelper getValueHelper(String value) {
        return this.lookup.get(value);
    }

    void addValueHelper(String key, ValueConstructionHelper helper) {
        this.lookup.put(key, helper);
    }

    public MultiselectDecisionItem getDecisionItem() {
        return this.decisionItem;
    }

    public String toString() {
        if (this.decisionItem == null) {
            return String.join((CharSequence)DELIMITER, this.lookup.keySet());
        }
        return this.decisionItem.getValue() + " -> " + String.join((CharSequence)DELIMITER, this.lookup.keySet());
    }

    public List<MultiselectDecisionItem> createItemList() {
        ArrayList<MultiselectDecisionItem> items = new ArrayList<MultiselectDecisionItem>();
        this.lookup.values().forEach(helper -> {
            MultiselectDecisionItem item = helper.getDecisionItem();
            items.add(item);
            item.setChildren(helper.createItemList());
        });
        return items;
    }
}

