/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import com.vladsch.flexmark.ext.emoji.EmojiExtension;
import com.vladsch.flexmark.ext.emoji.EmojiImageType;
import com.vladsch.flexmark.ext.emoji.EmojiShortcutType;
import com.vladsch.flexmark.ext.gfm.strikethrough.StrikethroughExtension;
import com.vladsch.flexmark.ext.gfm.tasklist.TaskListExtension;
import com.vladsch.flexmark.ext.tables.TablesExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import hudson.Extension;
import hudson.markup.MarkupFormatter;
import hudson.markup.MarkupFormatterDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.kohsuke.stapler.DataBoundConstructor;

public class MarkdownFormatter
extends MarkupFormatter {
    private static HtmlRenderer htmlRenderer = null;
    private static Parser markdownParser = null;
    private static MutableDataSet options = new MutableDataSet();

    @DataBoundConstructor
    public MarkdownFormatter() {
    }

    public void translate(String markup, Writer output) throws IOException {
        if (markup != null) {
            output.write(htmlRenderer.render((Node)markdownParser.parse(markup)));
        } else {
            output.write("");
        }
    }

    static {
        options.set(Parser.EXTENSIONS, Arrays.asList(TablesExtension.create(), StrikethroughExtension.create(), TaskListExtension.create(), EmojiExtension.create()));
        options.set(EmojiExtension.USE_IMAGE_TYPE, (Object)EmojiImageType.UNICODE_FALLBACK_TO_IMAGE);
        options.set(EmojiExtension.USE_SHORTCUT_TYPE, (Object)EmojiShortcutType.GITHUB);
        htmlRenderer = HtmlRenderer.builder((DataHolder)options).escapeHtml(true).build();
        markdownParser = Parser.builder((DataHolder)options).build();
    }

    @Extension
    public static class DescriptorImpl
    extends MarkupFormatterDescriptor {
        public String getDisplayName() {
            return "Markdown Formatter";
        }
    }
}

