/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.jakarta.activation;

import edu.umd.cs.findbugs.annotations.NonNull;
import jakarta.activation.CommandInfo;
import jakarta.activation.CommandMap;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import java.util.Objects;
import java.util.function.Supplier;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class DelegatingCommandMap
extends CommandMap {
    private final CommandMap delegate;

    public DelegatingCommandMap(@NonNull CommandMap delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T runWithContextClassLoader(Supplier<T> supplier) {
        Thread t = Thread.currentThread();
        ClassLoader orig = t.getContextClassLoader();
        t.setContextClassLoader(DelegatingCommandMap.class.getClassLoader());
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            t.setContextClassLoader(orig);
        }
    }

    public CommandInfo[] getPreferredCommands(String mimeType) {
        return DelegatingCommandMap.runWithContextClassLoader(() -> this.delegate.getPreferredCommands(mimeType));
    }

    public CommandInfo[] getPreferredCommands(String mimeType, DataSource ds) {
        return DelegatingCommandMap.runWithContextClassLoader(() -> this.delegate.getPreferredCommands(mimeType, ds));
    }

    public CommandInfo[] getAllCommands(String mimeType) {
        return DelegatingCommandMap.runWithContextClassLoader(() -> this.delegate.getAllCommands(mimeType));
    }

    public CommandInfo[] getAllCommands(String mimeType, DataSource ds) {
        return DelegatingCommandMap.runWithContextClassLoader(() -> this.delegate.getAllCommands(mimeType, ds));
    }

    public CommandInfo getCommand(String mimeType, String cmdName) {
        return DelegatingCommandMap.runWithContextClassLoader(() -> this.delegate.getCommand(mimeType, cmdName));
    }

    public CommandInfo getCommand(String mimeType, String cmdName, DataSource ds) {
        return DelegatingCommandMap.runWithContextClassLoader(() -> this.delegate.getCommand(mimeType, cmdName, ds));
    }

    public DataContentHandler createDataContentHandler(String mimeType) {
        return DelegatingCommandMap.runWithContextClassLoader(() -> this.delegate.createDataContentHandler(mimeType));
    }

    public DataContentHandler createDataContentHandler(String mimeType, DataSource ds) {
        return DelegatingCommandMap.runWithContextClassLoader(() -> this.delegate.createDataContentHandler(mimeType, ds));
    }

    public String[] getMimeTypes() {
        return DelegatingCommandMap.runWithContextClassLoader(() -> this.delegate.getMimeTypes());
    }
}

