/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.fontawesome;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.fontawesome.SvgTag;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class FontAwesomeIcons {
    private static final Logger LOGGER = Logger.getLogger(FontAwesomeIcons.class.getName());
    private static final String SVG_FILE_ENDING = ".svg";
    private static final String IMAGES_SYMBOLS_PATH = "images/symbols/";
    private static final String FONT_AWESOME_API_PLUGIN = "font-awesome-api";
    private static final String ICON_CLASS_NAME_PATTERN = "symbol-%s plugin-font-awesome-api";

    public static String getIconClassName(String icon) {
        return String.format(ICON_CLASS_NAME_PATTERN, icon);
    }

    public static Map<String, String> getAvailableIcons() {
        return FontAwesomeIcons.getAvailableIcons(null);
    }

    public static Map<String, String> getAvailableIcons(@CheckForNull SvgTag.FontAwesomeStyle filter) {
        return FontAwesomeIcons.getIconsFromClasspath(filter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Map<String, String> getIconsFromClasspath(@CheckForNull SvgTag.FontAwesomeStyle filter) {
        Enumeration<URL> urls = FontAwesomeIcons.class.getClassLoader().getResources(IMAGES_SYMBOLS_PATH);
        while (urls.hasMoreElements()) {
            Map<String, String> map;
            URL url = urls.nextElement();
            if (!StringUtils.contains((CharSequence)url.toExternalForm(), (CharSequence)FONT_AWESOME_API_PLUGIN)) continue;
            URI uri = url.toURI();
            if (!StringUtils.equals((CharSequence)uri.getScheme(), (CharSequence)"jar")) return FontAwesomeIcons.collectIcons(Paths.get(uri), filter);
            FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            try {
                map = FontAwesomeIcons.collectIcons(fileSystem.getPath(IMAGES_SYMBOLS_PATH, new String[0]), filter);
                if (fileSystem == null) return map;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem == null) throw throwable;
                    try {
                        fileSystem.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | URISyntaxException ex) {
                    LOGGER.log(Level.WARNING, "Unable to read available icons: Resource unavailable.", ex);
                    return new LinkedHashMap<String, String>();
                }
            }
            fileSystem.close();
            return map;
        }
        return new LinkedHashMap<String, String>();
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    private static Map<String, String> collectIcons(@CheckForNull Path path, @CheckForNull SvgTag.FontAwesomeStyle filter) throws IOException {
        LinkedHashMap<String, String> icons = new LinkedHashMap<String, String>();
        if (path != null) {
            try (Stream<Path> stream = FontAwesomeIcons.findIcons(path, filter);){
                stream.filter(icon -> icon != null && icon.getFileName() != null && StringUtils.endsWith((CharSequence)icon.getFileName().toString(), (CharSequence)SVG_FILE_ENDING)).sorted().forEach(icon -> {
                    if (icon.getParent() != null && icon.getParent().getFileName() != null && icon.getFileName() != null) {
                        String iconName = String.valueOf(icon.getParent().getFileName()) + "/" + StringUtils.removeEnd((String)icon.getFileName().toString(), (String)SVG_FILE_ENDING);
                        icons.put(iconName, FontAwesomeIcons.getIconClassName(iconName));
                    }
                });
            }
        }
        return icons;
    }

    private static Stream<Path> findIcons(Path path, @CheckForNull SvgTag.FontAwesomeStyle filter) throws IOException {
        if (filter == null) {
            return Files.walk(path, 2, new FileVisitOption[0]);
        }
        return Files.walk(path.resolve(filter.name().toLowerCase(Locale.ENGLISH)), 1, new FileVisitOption[0]);
    }

    private FontAwesomeIcons() {
    }
}

