/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.rest.v30.client;

import com.embotics.vlm.rest.v30.client.ClientUtils;
import com.embotics.vlm.rest.v30.client.model.VCommanderException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class SessionsClient {
    private static final String TOKEN_PATH = "tokens";
    private static final String PROPERTY_USERNAME = "username";
    private static final String PROPERTY_PASSWORD = "password";
    private static final String PROPERTY_ORGANIZATION = "organization";
    private static final String PROPERTY_TOKEN = "token";
    private final String username;
    private final String password;
    private final String organization;
    private final WebResource webResource;

    public SessionsClient(WebResource webResource, String username, String password, String organization) {
        this.webResource = webResource;
        this.username = username;
        this.password = password;
        this.organization = organization;
    }

    public String getSecurityToken() throws JSONException, VCommanderException {
        JSONObject newTokenRequest = new JSONObject();
        newTokenRequest.put(PROPERTY_USERNAME, (Object)this.username);
        newTokenRequest.put(PROPERTY_PASSWORD, (Object)this.password);
        if (StringUtils.isNotBlank((String)this.organization)) {
            newTokenRequest.put(PROPERTY_ORGANIZATION, (Object)this.organization);
        }
        ClientResponse newTokenResponse = (ClientResponse)this.webResource.path(TOKEN_PATH).type("application/json").post(ClientResponse.class, (Object)newTokenRequest.toString());
        ClientUtils.checkResponse(newTokenResponse, ClientResponse.Status.CREATED.getStatusCode());
        String tokenStr = (String)newTokenResponse.getEntity(String.class);
        JSONObject tokenJSON = new JSONObject(tokenStr);
        return tokenJSON.getString(PROPERTY_TOKEN);
    }
}

