/*
 * Decompiled with CFR 0.152.
 */
package com.embotics.vlm.plugin.actions;

import com.embotics.vlm.plugin.Messages;
import com.embotics.vlm.plugin.VCommanderAction;
import com.embotics.vlm.plugin.VCommanderConfig;
import com.embotics.vlm.plugin.actions.AbstractVCommanderAction;
import com.embotics.vlm.plugin.actions.PluginUtils;
import com.embotics.vlm.plugin.actions.VCommanderRequestNewServiceAction;
import com.embotics.vlm.rest.v30.client.VCommanderClient;
import com.embotics.vlm.rest.v30.client.model.VCommanderException;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class VCommanderWaitForRequestNewServiceAction
extends AbstractVCommanderAction {
    private final String requestId;
    @Extension(ordinal=165.0)
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public VCommanderWaitForRequestNewServiceAction(String requestId, Long timeout, Long polling) {
        super(true, timeout, polling);
        this.requestId = requestId;
    }

    public String getRequestId() {
        return this.requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(Run<?, ?> run, TaskListener listener) throws InterruptedException, IOException {
        String requestIdStr = this.requestId;
        if (requestIdStr != null) {
            requestIdStr = Util.replaceMacro((String)requestIdStr, (Map)run.getEnvironment(listener));
        }
        Long numericRequestId = null;
        if (StringUtils.isNotBlank((String)requestIdStr)) {
            try {
                numericRequestId = Long.valueOf(requestIdStr);
            }
            catch (NumberFormatException e) {
                listener.getLogger().println(e);
            }
        }
        if (numericRequestId == null) {
            throw new VCommanderException("Error in build step configuration. RequestId is not specified.");
        }
        listener.getLogger().println(client.getClientInfo());
        try (VCommanderClient client = VCommanderConfig.getVCommanderClient();){
            VCommanderRequestNewServiceAction.waitForServiceRequestToBeCompleted(client, numericRequestId, this.getTimeout(), this.getPolling(), run, listener);
        }
    }

    public Descriptor<VCommanderAction> getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class DescriptorImpl
    extends AbstractVCommanderAction.AbstractVCommanderActionDescriptor {
        public String getDisplayName() {
            return Messages.VCommanderWaitForRequestNewServiceAction_DisplayName();
        }

        public String getDefaultRequestId() {
            return "$VCOMMANDER_REQUESTED_SERVICE_ID";
        }

        public FormValidation doCheckRequestId(@QueryParameter String requestId) throws IOException, ServletException {
            if (PluginUtils.isNumericOrVariable(requestId)) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)Messages.VCommanderWaitForRequestNewServiceAction_errors_requestId());
        }
    }
}

