/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts;

import edu.hm.hafner.echarts.JacksonFacade;
import edu.hm.hafner.echarts.LineSeries;
import edu.hm.hafner.echarts.LinesDataSet;
import edu.hm.hafner.util.Generated;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LinesChartModel {
    private final List<String> domainAxisLabels = new ArrayList<String>();
    private final List<Integer> buildNumbers = new ArrayList<Integer>();
    private final List<LineSeries> series = new ArrayList<LineSeries>();
    private String domainAxisItemName = "Build";
    private boolean integerRangeAxis = true;
    @CheckForNull
    private Integer rangeMax;
    @CheckForNull
    private Integer rangeMin;

    public LinesChartModel(LinesDataSet dataSet) {
        this();
        if (!dataSet.isEmpty()) {
            this.domainAxisLabels.addAll(dataSet.getDomainAxisLabels());
            this.buildNumbers.addAll(dataSet.getBuildNumbers());
        }
    }

    public LinesChartModel(List<String> labels, List<Integer> builds) {
        this.domainAxisLabels.addAll(labels);
        this.buildNumbers.addAll(builds);
    }

    public LinesChartModel() {
    }

    public void setDomainAxisItemName(String name) {
        this.domainAxisItemName = name;
    }

    public String getDomainAxisItemName() {
        return this.domainAxisItemName;
    }

    public void useContinuousRangeAxis() {
        this.integerRangeAxis = false;
    }

    public boolean isIntegerRangeAxis() {
        return this.integerRangeAxis;
    }

    public void setRangeMax(int rangeMax) {
        this.rangeMax = rangeMax;
    }

    @CheckForNull
    public Integer getRangeMax() {
        return this.rangeMax;
    }

    public void setRangeMin(int rangeMin) {
        this.rangeMin = rangeMin;
    }

    @CheckForNull
    public Integer getRangeMin() {
        return this.rangeMin;
    }

    public void setDomainAxisLabels(List<String> labels) {
        this.domainAxisLabels.addAll(labels);
    }

    public void setBuildNumbers(List<Integer> builds) {
        this.buildNumbers.addAll(builds);
    }

    void addSeries(List<LineSeries> lineSeries) {
        this.series.addAll(lineSeries);
    }

    public void addSeries(LineSeries ... lineSeries) {
        Collections.addAll(this.series, lineSeries);
    }

    public List<String> getDomainAxisLabels() {
        return this.domainAxisLabels;
    }

    public List<Integer> getBuildNumbers() {
        return this.buildNumbers;
    }

    public List<LineSeries> getSeries() {
        return this.series;
    }

    public int size() {
        return this.domainAxisLabels.size();
    }

    @Generated
    public String toString() {
        return new JacksonFacade().toJson(this);
    }
}

