/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.echarts;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

class LocalDateLabel
implements Comparable<LocalDateLabel> {
    private final LocalDate date;
    private final DateTimeFormatter formatter;

    LocalDateLabel(LocalDate date) {
        this.date = date;
        this.formatter = DateTimeFormatter.ofPattern("MM-dd");
    }

    @Override
    public int compareTo(@NonNull LocalDateLabel o) {
        return this.date.compareTo(o.date);
    }

    public String toString() {
        return this.formatter.format(this.date);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalDateLabel that = (LocalDateLabel)o;
        return this.date.equals(that.date) && this.formatter.equals(that.formatter);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.formatter);
    }
}

